/* hapmapPhaseIIISummary.c was originally generated by the autoSql program, which also 
 * generated hapmapPhaseIIISummary.h and hapmapPhaseIIISummary.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hapmapPhaseIIISummary.h"


struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoad(char **row)
/* Load a hapmapPhaseIIISummary from row fetched with select * from hapmapPhaseIIISummary
 * from database.  Dispose of this with hapmapPhaseIIISummaryFree(). */
{
struct hapmapPhaseIIISummary *ret;

AllocVar(ret);
ret->orthoCount = sqlUnsigned(row[15]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
ret->observed = cloneString(row[5]);
ret->overallMajorAllele = row[6][0];
ret->overallMinorAllele = row[7][0];
ret->popCount = sqlUnsigned(row[8]);
ret->phaseIIPopCount = sqlUnsigned(row[9]);
ret->isMixed = sqlUnsigned(row[10]);
sqlUbyteArray(row[11], ret->foundInPop, 11);
sqlUbyteArray(row[12], ret->monomorphicInPop, 11);
ret->minFreq = sqlFloat(row[13]);
ret->maxFreq = sqlFloat(row[14]);
{
int sizeOne;
sqlCharDynamicArray(row[16], &ret->orthoAlleles, &sizeOne);
assert(sizeOne == ret->orthoCount);
}
{
int sizeOne;
sqlUshortDynamicArray(row[17], &ret->orthoQuals, &sizeOne);
assert(sizeOne == ret->orthoCount);
}
return ret;
}

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoadAll(char *fileName) 
/* Load all hapmapPhaseIIISummary from a whitespace-separated file.
 * Dispose of this with hapmapPhaseIIISummaryFreeList(). */
{
struct hapmapPhaseIIISummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = hapmapPhaseIIISummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoadAllByChar(char *fileName, char chopper) 
/* Load all hapmapPhaseIIISummary from a chopper separated file.
 * Dispose of this with hapmapPhaseIIISummaryFreeList(). */
{
struct hapmapPhaseIIISummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hapmapPhaseIIISummaryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryCommaIn(char **pS, struct hapmapPhaseIIISummary *ret)
/* Create a hapmapPhaseIIISummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapPhaseIIISummary */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
ret->observed = sqlStringComma(&s);
sqlFixedStringComma(&s, &(ret->overallMajorAllele), sizeof(ret->overallMajorAllele));
sqlFixedStringComma(&s, &(ret->overallMinorAllele), sizeof(ret->overallMinorAllele));
ret->popCount = sqlUnsignedComma(&s);
ret->phaseIIPopCount = sqlUnsignedComma(&s);
ret->isMixed = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<11; ++i)
    {
    ret->foundInPop[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<11; ++i)
    {
    ret->monomorphicInPop[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->minFreq = sqlFloatComma(&s);
ret->maxFreq = sqlFloatComma(&s);
ret->orthoCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->orthoAlleles, ret->orthoCount);
for (i=0; i<ret->orthoCount; ++i)
    {
    ret->orthoAlleles[i] = sqlCharComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->orthoQuals, ret->orthoCount);
for (i=0; i<ret->orthoCount; ++i)
    {
    ret->orthoQuals[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void hapmapPhaseIIISummaryFree(struct hapmapPhaseIIISummary **pEl)
/* Free a single dynamically allocated hapmapPhaseIIISummary such as created
 * with hapmapPhaseIIISummaryLoad(). */
{
struct hapmapPhaseIIISummary *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->observed);
freeMem(el->orthoAlleles);
freeMem(el->orthoQuals);
freez(pEl);
}

void hapmapPhaseIIISummaryFreeList(struct hapmapPhaseIIISummary **pList)
/* Free a list of dynamically allocated hapmapPhaseIIISummary's */
{
struct hapmapPhaseIIISummary *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hapmapPhaseIIISummaryFree(&el);
    }
*pList = NULL;
}

void hapmapPhaseIIISummaryOutput(struct hapmapPhaseIIISummary *el, FILE *f, char sep, char lastSep) 
/* Print out hapmapPhaseIIISummary.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->observed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->overallMajorAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->overallMinorAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->popCount);
fputc(sep,f);
fprintf(f, "%u", el->phaseIIPopCount);
fputc(sep,f);
fprintf(f, "%u", el->isMixed);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<11; ++i)
    {
    fprintf(f, "%u", el->foundInPop[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<11; ++i)
    {
    fprintf(f, "%u", el->monomorphicInPop[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%g", el->minFreq);
fputc(sep,f);
fprintf(f, "%g", el->maxFreq);
fputc(sep,f);
fprintf(f, "%u", el->orthoCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->orthoCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%c", el->orthoAlleles[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->orthoCount; ++i)
    {
    fprintf(f, "%u", el->orthoQuals[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

