/* namedSessionDb.h was originally generated by the autoSql program, which also 
 * generated namedSessionDb.c and namedSessionDb.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef NAMEDSESSIONDB_H
#define NAMEDSESSIONDB_H

#define NAMEDSESSIONDB_NUM_COLS 8

extern char *namedSessionDbCommaSepFieldNames;

struct namedSessionDb
/* Named user sessions. */
    {
    struct namedSessionDb *next;  /* Next in singly linked list. */
    char *userName;	/* User name (from genomewiki). */
    char *sessionName;	/* Name that user assigns to this session */
    char *contents;	/* CGI string of var=val&... settings. */
    signed char shared;	/* 1 if this session may be shared with other users, 2 if added to the public listing. */
    char *firstUse;	/* Session creation date. */
    char *lastUse;	/* Session most-recent-usage date. */
    int useCount;	/* Number of times this session has been used. */
    char *settings;	/* .ra-formatted metadata */
    };

void namedSessionDbStaticLoad(char **row, struct namedSessionDb *ret);
/* Load a row from namedSessionDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct namedSessionDb *namedSessionDbLoad(char **row);
/* Load a namedSessionDb from row fetched with select * from namedSessionDb
 * from database.  Dispose of this with namedSessionDbFree(). */

struct namedSessionDb *namedSessionDbLoadAll(char *fileName);
/* Load all namedSessionDb from whitespace-separated file.
 * Dispose of this with namedSessionDbFreeList(). */

struct namedSessionDb *namedSessionDbLoadAllByChar(char *fileName, char chopper);
/* Load all namedSessionDb from chopper separated file.
 * Dispose of this with namedSessionDbFreeList(). */

#define namedSessionDbLoadAllByTab(a) namedSessionDbLoadAllByChar(a, '\t');
/* Load all namedSessionDb from tab separated file.
 * Dispose of this with namedSessionDbFreeList(). */

struct namedSessionDb *namedSessionDbCommaIn(char **pS, struct namedSessionDb *ret);
/* Create a namedSessionDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new namedSessionDb */

void namedSessionDbFree(struct namedSessionDb **pEl);
/* Free a single dynamically allocated namedSessionDb such as created
 * with namedSessionDbLoad(). */

void namedSessionDbFreeList(struct namedSessionDb **pList);
/* Free a list of dynamically allocated namedSessionDb's */

void namedSessionDbOutput(struct namedSessionDb *el, FILE *f, char sep, char lastSep);
/* Print out namedSessionDb.  Separate fields with sep. Follow last field with lastSep. */

#define namedSessionDbTabOut(el,f) namedSessionDbOutput(el,f,'\t','\n');
/* Print out namedSessionDb as a line in a tab-separated file. */

#define namedSessionDbCommaOut(el,f) namedSessionDbOutput(el,f,',',',');
/* Print out namedSessionDb as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* NAMEDSESSIONDB_H */

