/* gtexAse.h was originally generated by the autoSql program, which also 
 * generated gtexAse.c and gtexAse.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GTEXASE_H
#define GTEXASE_H

#include "jksql.h"
#define GTEXASE_NUM_COLS 18

extern char *gtexAseCommaSepFieldNames;

struct gtexAse
/* BED9+ with additional fields for ASE, coverage, and sample count */
    {
    struct gtexAse *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* SNP Id */
    unsigned score;	/* Score from 0-1000; derived from median ASE level */
    char strand[2];	/* n/a */
    unsigned thickStart;	/* n/a */
    unsigned thickEnd;	/* n/a */
    unsigned itemRgb;	/* Color by binned ASE value (none, moderate, strong) */
    float medianASE;	/* Allelic imbalance (0-.5) median */
    float coverage;	/* RNA-seq reads overlapping this position (median) */
    unsigned samples;	/* Sample count */
    unsigned donors;	/* Donor count */
    float minASE;	/* Minimum ASE */
    float q1ASE;	/* Q1 ASE */
    float q3ASE;	/* Q3 ASE */
    float maxASE;	/* Maximum ASE */
    float stdASE;	/* ASE standard deviation */
    };

void gtexAseStaticLoad(char **row, struct gtexAse *ret);
/* Load a row from gtexAse table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gtexAse *gtexAseLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all gtexAse from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexAseFreeList(). */

void gtexAseSaveToDb(struct sqlConnection *conn, struct gtexAse *el, char *tableName, int updateSize);
/* Save gtexAse as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct gtexAse *gtexAseLoad(char **row);
/* Load a gtexAse from row fetched with select * from gtexAse
 * from database.  Dispose of this with gtexAseFree(). */

struct gtexAse *gtexAseLoadAll(char *fileName);
/* Load all gtexAse from whitespace-separated file.
 * Dispose of this with gtexAseFreeList(). */

struct gtexAse *gtexAseLoadAllByChar(char *fileName, char chopper);
/* Load all gtexAse from chopper separated file.
 * Dispose of this with gtexAseFreeList(). */

#define gtexAseLoadAllByTab(a) gtexAseLoadAllByChar(a, '\t');
/* Load all gtexAse from tab separated file.
 * Dispose of this with gtexAseFreeList(). */

struct gtexAse *gtexAseCommaIn(char **pS, struct gtexAse *ret);
/* Create a gtexAse out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexAse */

void gtexAseFree(struct gtexAse **pEl);
/* Free a single dynamically allocated gtexAse such as created
 * with gtexAseLoad(). */

void gtexAseFreeList(struct gtexAse **pList);
/* Free a list of dynamically allocated gtexAse's */

void gtexAseOutput(struct gtexAse *el, FILE *f, char sep, char lastSep);
/* Print out gtexAse.  Separate fields with sep. Follow last field with lastSep. */

#define gtexAseTabOut(el,f) gtexAseOutput(el,f,'\t','\n');
/* Print out gtexAse as a line in a tab-separated file. */

#define gtexAseCommaOut(el,f) gtexAseOutput(el,f,',',',');
/* Print out gtexAse as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GTEXASE_H */

