/* encodeStanfordPromoters.h was originally generated by the autoSql program, which also 
 * generated encodeStanfordPromoters.c and encodeStanfordPromoters.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENCODESTANFORDPROMOTERS_H
#define ENCODESTANFORDPROMOTERS_H

#define ENCODESTANFORDPROMOTERS_NUM_COLS 18

struct encodeStanfordPromoters
/* Stanford Promoter Activity in ENCODE Regions (bed 9+) */
    {
    struct encodeStanfordPromoters *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* accession of mRNA used to predict the promoter */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Placeholder for BED9 format -- same as chromStart */
    unsigned thickEnd;	/* Placeholder for BED9 format -- same as chromEnd */
    unsigned reserved;	/* Used as itemRgb */
    char *geneModel;	/* Gene model ID; same ID may have multiple predicted promoters */
    char *description;	/* Gene description */
    int lucA;	/* Luciferase signal A */
    int renA;	/* Renilla signal A */
    int lucB;	/* Luciferase signal B */
    int renB;	/* Renilla signal B */
    float avgRatio;	/* Average Luciferase/Renilla Ratio */
    float normRatio;	/* Normalized Luciferase/Renilla Ratio */
    float normLog2Ratio;	/* Normalized and log2 transformed Luciferase Renilla Ratio */
    };

void encodeStanfordPromotersStaticLoad(char **row, struct encodeStanfordPromoters *ret);
/* Load a row from encodeStanfordPromoters table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct encodeStanfordPromoters *encodeStanfordPromotersLoad(char **row);
/* Load a encodeStanfordPromoters from row fetched with select * from encodeStanfordPromoters
 * from database.  Dispose of this with encodeStanfordPromotersFree(). */

struct encodeStanfordPromoters *encodeStanfordPromotersLoadAll(char *fileName);
/* Load all encodeStanfordPromoters from whitespace-separated file.
 * Dispose of this with encodeStanfordPromotersFreeList(). */

struct encodeStanfordPromoters *encodeStanfordPromotersLoadAllByChar(char *fileName, char chopper);
/* Load all encodeStanfordPromoters from chopper separated file.
 * Dispose of this with encodeStanfordPromotersFreeList(). */

#define encodeStanfordPromotersLoadAllByTab(a) encodeStanfordPromotersLoadAllByChar(a, '\t');
/* Load all encodeStanfordPromoters from tab separated file.
 * Dispose of this with encodeStanfordPromotersFreeList(). */

struct encodeStanfordPromoters *encodeStanfordPromotersCommaIn(char **pS, struct encodeStanfordPromoters *ret);
/* Create a encodeStanfordPromoters out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeStanfordPromoters */

void encodeStanfordPromotersFree(struct encodeStanfordPromoters **pEl);
/* Free a single dynamically allocated encodeStanfordPromoters such as created
 * with encodeStanfordPromotersLoad(). */

void encodeStanfordPromotersFreeList(struct encodeStanfordPromoters **pList);
/* Free a list of dynamically allocated encodeStanfordPromoters's */

void encodeStanfordPromotersOutput(struct encodeStanfordPromoters *el, FILE *f, char sep, char lastSep);
/* Print out encodeStanfordPromoters.  Separate fields with sep. Follow last field with lastSep. */

#define encodeStanfordPromotersTabOut(el,f) encodeStanfordPromotersOutput(el,f,'\t','\n');
/* Print out encodeStanfordPromoters as a line in a tab-separated file. */

#define encodeStanfordPromotersCommaOut(el,f) encodeStanfordPromotersOutput(el,f,',',',');
/* Print out encodeStanfordPromoters as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENCODESTANFORDPROMOTERS_H */

