# Tissue colors, in alpha order

colors <- c(
16753999,
15636992,
9419919,
9116770,
15624784,
16711680,
13481886,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
15658496,
52685,
15631086,
10141901,
13481886,
15648145,
15652306,
15652306,
9139029,
9139029,
13478525,
15652306,
11817677,
8009611,
13481886,
13481886,
13481886,
10145074,
13481886,
8021998,
16766720,
16758465,
13474589,
11857588,
14277081,
2003199,
3825613,
13481886,
13481886,
16765851,
10921638,
35653,
15652306,
15652306,
16711935)

colorsHex<-paste("#",format(as.hexmode(colors), width=6), sep="")

# again, but replace yellow with dark gray
darkerColors <- c(
16753999,
15636992,
9419919,
9116770,
15624784,
16711680,
13481886,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
7566195,
52685,
15631086,
10141901,
13481886,
15648145,
15652306,
15652306,
9139029,
9139029,
13478525,
15652306,
11817677,
8009611,
13481886,
13481886,
13481886,
10145074,
13481886,
8021998,
16766720,
16758465,
13474589,
11857588,
14277081,
2003199,
3825613,
13481886,
13481886,
16765851,
10921638,
35653,
15652306,
15652306,
16711935)

darkerColorsHex<-paste("#",format(as.hexmode(darkerColors), width=6), sep="")

# Get the below list by querying the gtexTissueV8 table:
# hgsql -Ne "select description from gtexTissueV8 order by id" hgFixed | \
#     cut -d'(' -f1 | sed -e 's/^/"/' -e 's/$/",/'
tissueOrder <- c(
"Adipose - Subcutaneous",
"Adipose - Visceral ",
"Adrenal Gland",
"Artery - Aorta",
"Artery - Coronary",
"Artery - Tibial",
"Bladder",
"Brain - Amygdala",
"Brain - Anterior cingulate cortex ",
"Brain - Caudate ",
"Brain - Cerebellar Hemisphere",
"Brain - Cerebellum",
"Brain - Cortex",
"Brain - Frontal Cortex ",
"Brain - Hippocampus",
"Brain - Hypothalamus",
"Brain - Nucleus accumbens ",
"Brain - Putamen ",
"Brain - Spinal cord ",
"Brain - Substantia nigra",
"Breast - Mammary Tissue",
"Cells - EBV-transformed lymphocytes",
"Cells - Cultured fibroblasts",
"Cervix - Ectocervix",
"Cervix - Endocervix",
"Colon - Sigmoid",
"Colon - Transverse",
"Esophagus - Gastroesophageal Junction",
"Esophagus - Mucosa",
"Esophagus - Muscularis",
"Fallopian Tube",
"Heart - Atrial Appendage",
"Heart - Left Ventricle",
"Kidney - Cortex",
"Kidney - Medulla",
"Liver",
"Lung",
"Minor Salivary Gland",
"Muscle - Skeletal",
"Nerve - Tibial",
"Ovary",
"Pancreas",
"Pituitary",
"Prostate",
"Skin - Not Sun Exposed ",
"Skin - Sun Exposed ",
"Small Intestine - Terminal Ileum",
"Spleen",
"Stomach",
"Testis",
"Thyroid",
"Uterus",
"Vagina",
"Whole Blood")
