/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jvyaml.Constructor;
import org.jvyaml.DefaultYAMLConfig;
import org.jvyaml.DefaultYAMLFactory;
import org.jvyaml.Representer;
import org.jvyaml.Serializer;
import org.jvyaml.YAMLConfig;
import org.jvyaml.YAMLException;
import org.jvyaml.YAMLFactory;

public class YAML {
    public static final String DEFAULT_SCALAR_TAG = "tag:yaml.org,2002:str";
    public static final String DEFAULT_SEQUENCE_TAG = "tag:yaml.org,2002:seq";
    public static final String DEFAULT_MAPPING_TAG = "tag:yaml.org,2002:map";
    public static final Map ESCAPE_REPLACEMENTS = new HashMap();

    public static YAMLConfig config() {
        return YAML.defaultConfig();
    }

    public static YAMLConfig defaultConfig() {
        return new DefaultYAMLConfig();
    }

    public static String dump(Object data) {
        return YAML.dump(data, YAML.config());
    }

    public static String dump(Object data, YAMLFactory fact) {
        return YAML.dump(data, fact, YAML.config());
    }

    public static String dump(Object data, YAMLConfig cfg) {
        ArrayList<Object> lst = new ArrayList<Object>(1);
        lst.add(data);
        return YAML.dumpAll(lst, cfg);
    }

    public static String dump(Object data, YAMLFactory fact, YAMLConfig cfg) {
        ArrayList<Object> lst = new ArrayList<Object>(1);
        lst.add(data);
        return YAML.dumpAll(lst, fact, cfg);
    }

    public static String dumpAll(List data) {
        return YAML.dumpAll(data, YAML.config());
    }

    public static String dumpAll(List data, YAMLFactory fact) {
        return YAML.dumpAll(data, fact, YAML.config());
    }

    public static String dumpAll(List data, YAMLConfig cfg) {
        StringWriter swe = new StringWriter();
        YAML.dumpAll(data, (Writer)swe, cfg);
        return swe.toString();
    }

    public static String dumpAll(List data, YAMLFactory fact, YAMLConfig cfg) {
        StringWriter swe = new StringWriter();
        YAML.dumpAll(data, swe, fact, cfg);
        return swe.toString();
    }

    public static void dump(Object data, Writer output) {
        YAML.dump(data, output, YAML.config());
    }

    public static void dump(Object data, Writer output, YAMLFactory fact) {
        YAML.dump(data, output, fact, YAML.config());
    }

    public static void dump(Object data, Writer output, YAMLConfig cfg) {
        ArrayList<Object> lst = new ArrayList<Object>(1);
        lst.add(data);
        YAML.dumpAll(lst, output, cfg);
    }

    public static void dump(Object data, Writer output, YAMLFactory fact, YAMLConfig cfg) {
        ArrayList<Object> lst = new ArrayList<Object>(1);
        lst.add(data);
        YAML.dumpAll(lst, output, fact, cfg);
    }

    public static void dumpAll(List data, Writer output) {
        YAML.dumpAll(data, output, YAML.config());
    }

    public static void dumpAll(List data, Writer output, YAMLFactory fact) {
        YAML.dumpAll(data, output, fact, YAML.config());
    }

    public static void dumpAll(List data, Writer output, YAMLConfig cfg) {
        YAML.dumpAll(data, output, new DefaultYAMLFactory(), cfg);
    }

    public static void dumpAll(List data, Writer output, YAMLFactory fact, YAMLConfig cfg) {
        Serializer s = fact.createSerializer(fact.createEmitter(output, cfg), fact.createResolver(), cfg);
        try {
            s.open();
            Representer r = fact.createRepresenter(s, cfg);
            Iterator iter = data.iterator();
            while (iter.hasNext()) {
                r.represent(iter.next());
            }
        }
        catch (IOException e) {
            throw new YAMLException(e);
        }
        finally {
            try {
                s.close();
            }
            catch (IOException e) {}
        }
    }

    public static Object load(String io) {
        return YAML.load(io, (YAMLFactory)new DefaultYAMLFactory(), YAML.config());
    }

    public static Object load(Reader io) {
        return YAML.load(io, (YAMLFactory)new DefaultYAMLFactory(), YAML.config());
    }

    public static Object load(String io, YAMLConfig cfg) {
        return YAML.load(io, (YAMLFactory)new DefaultYAMLFactory(), cfg);
    }

    public static Object load(Reader io, YAMLConfig cfg) {
        return YAML.load(io, (YAMLFactory)new DefaultYAMLFactory(), cfg);
    }

    public static Object load(String io, YAMLFactory fact, YAMLConfig cfg) {
        Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner(io), cfg), fact.createResolver()));
        if (ctor.checkData()) {
            return ctor.getData();
        }
        return null;
    }

    public static Object load(Reader io, YAMLFactory fact, YAMLConfig cfg) {
        Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner(io), cfg), fact.createResolver()));
        if (ctor.checkData()) {
            return ctor.getData();
        }
        return null;
    }

    public static List loadAll(String io) {
        return YAML.loadAll(io, (YAMLFactory)new DefaultYAMLFactory(), YAML.config());
    }

    public static List loadAll(Reader io) {
        return YAML.loadAll(io, (YAMLFactory)new DefaultYAMLFactory(), YAML.config());
    }

    public static List loadAll(String io, YAMLConfig cfg) {
        return YAML.loadAll(io, (YAMLFactory)new DefaultYAMLFactory(), cfg);
    }

    public static List loadAll(Reader io, YAMLConfig cfg) {
        return YAML.loadAll(io, (YAMLFactory)new DefaultYAMLFactory(), cfg);
    }

    public static List loadAll(String io, YAMLFactory fact, YAMLConfig cfg) {
        ArrayList<Object> result = new ArrayList<Object>();
        Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner(io), cfg), fact.createResolver()));
        while (ctor.checkData()) {
            result.add(ctor.getData());
        }
        return result;
    }

    public static List loadAll(Reader io, YAMLFactory fact, YAMLConfig cfg) {
        ArrayList<Object> result = new ArrayList<Object>();
        Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner(io), cfg), fact.createResolver()));
        while (ctor.checkData()) {
            result.add(ctor.getData());
        }
        return result;
    }

    static {
        ESCAPE_REPLACEMENTS.put(new Character('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(new Character('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(new Character('\b'), "b");
        ESCAPE_REPLACEMENTS.put(new Character('\t'), "t");
        ESCAPE_REPLACEMENTS.put(new Character('\n'), "n");
        ESCAPE_REPLACEMENTS.put(new Character('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(new Character('\f'), "f");
        ESCAPE_REPLACEMENTS.put(new Character('\r'), "r");
        ESCAPE_REPLACEMENTS.put(new Character('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(new Character('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(new Character('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(new Character('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(new Character('\u00a0'), "_");
    }
}

