/* namedSessionDb.c was originally generated by the autoSql program, which also 
 * generated namedSessionDb.h and namedSessionDb.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "namedSessionDb.h"



char *namedSessionDbCommaSepFieldNames = "userName,sessionName,contents,shared,firstUse,lastUse,useCount,settings";

void namedSessionDbStaticLoad(char **row, struct namedSessionDb *ret)
/* Load a row from namedSessionDb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->userName = row[0];
ret->sessionName = row[1];
ret->contents = row[2];
ret->shared = sqlSigned(row[3]);
ret->firstUse = row[4];
ret->lastUse = row[5];
ret->useCount = sqlSigned(row[6]);
ret->settings = row[7];
}

struct namedSessionDb *namedSessionDbLoad(char **row)
/* Load a namedSessionDb from row fetched with select * from namedSessionDb
 * from database.  Dispose of this with namedSessionDbFree(). */
{
struct namedSessionDb *ret;

AllocVar(ret);
ret->userName = cloneString(row[0]);
ret->sessionName = cloneString(row[1]);
ret->contents = cloneString(row[2]);
ret->shared = sqlSigned(row[3]);
ret->firstUse = cloneString(row[4]);
ret->lastUse = cloneString(row[5]);
ret->useCount = sqlSigned(row[6]);
ret->settings = cloneString(row[7]);
return ret;
}

struct namedSessionDb *namedSessionDbLoadAll(char *fileName) 
/* Load all namedSessionDb from a whitespace-separated file.
 * Dispose of this with namedSessionDbFreeList(). */
{
struct namedSessionDb *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = namedSessionDbLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct namedSessionDb *namedSessionDbLoadAllByChar(char *fileName, char chopper) 
/* Load all namedSessionDb from a chopper separated file.
 * Dispose of this with namedSessionDbFreeList(). */
{
struct namedSessionDb *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = namedSessionDbLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct namedSessionDb *namedSessionDbCommaIn(char **pS, struct namedSessionDb *ret)
/* Create a namedSessionDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new namedSessionDb */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->userName = sqlStringComma(&s);
ret->sessionName = sqlStringComma(&s);
ret->contents = sqlStringComma(&s);
ret->shared = sqlSignedComma(&s);
ret->firstUse = sqlStringComma(&s);
ret->lastUse = sqlStringComma(&s);
ret->useCount = sqlSignedComma(&s);
ret->settings = sqlStringComma(&s);
*pS = s;
return ret;
}

void namedSessionDbFree(struct namedSessionDb **pEl)
/* Free a single dynamically allocated namedSessionDb such as created
 * with namedSessionDbLoad(). */
{
struct namedSessionDb *el;

if ((el = *pEl) == NULL) return;
freeMem(el->userName);
freeMem(el->sessionName);
freeMem(el->contents);
freeMem(el->firstUse);
freeMem(el->lastUse);
freeMem(el->settings);
freez(pEl);
}

void namedSessionDbFreeList(struct namedSessionDb **pList)
/* Free a list of dynamically allocated namedSessionDb's */
{
struct namedSessionDb *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    namedSessionDbFree(&el);
    }
*pList = NULL;
}

void namedSessionDbOutput(struct namedSessionDb *el, FILE *f, char sep, char lastSep) 
/* Print out namedSessionDb.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->userName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sessionName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->contents);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->shared);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->firstUse);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lastUse);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->useCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->settings);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

