table bedHeatmap
"Browser extensible data (12 fields) plus extensions for heatmap data."
    (
    string chrom;      "Chromosome (or contig, scaffold, etc.)"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    int blockCount;    "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    int _rowCount;    "Number of heatmap rows"
    string[_rowCount] _labels; "Comma separated list of row labels"
    lstring _colorBounds; "Comma-separated list of threshold scores for colors"
    lstring _colorValues; "Comma-separated list of colors, one for each threshold score"
    lstring _scoreArray; "Comma-separated row-first list of scores, ,, indicates N/A"
    lstring _labelArray; "Comma-separated row-first list of mouseover labels, ,, indicates N/A"
    lstring legend; "Legend"
    )
