/* gtexDonor.c was originally generated by the autoSql program, which also 
 * generated gtexDonor.h and gtexDonor.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexDonor.h"



char *gtexDonorCommaSepFieldNames = "name,gender,age,deathClass";

void gtexDonorStaticLoad(char **row, struct gtexDonor *ret)
/* Load a row from gtexDonor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->gender = row[1];
ret->age = sqlUnsigned(row[2]);
ret->deathClass = sqlSigned(row[3]);
}

struct gtexDonor *gtexDonorLoad(char **row)
/* Load a gtexDonor from row fetched with select * from gtexDonor
 * from database.  Dispose of this with gtexDonorFree(). */
{
struct gtexDonor *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->gender = cloneString(row[1]);
ret->age = sqlUnsigned(row[2]);
ret->deathClass = sqlSigned(row[3]);
return ret;
}

struct gtexDonor *gtexDonorLoadAll(char *fileName) 
/* Load all gtexDonor from a whitespace-separated file.
 * Dispose of this with gtexDonorFreeList(). */
{
struct gtexDonor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = gtexDonorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexDonor *gtexDonorLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexDonor from a chopper separated file.
 * Dispose of this with gtexDonorFreeList(). */
{
struct gtexDonor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexDonorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexDonor *gtexDonorCommaIn(char **pS, struct gtexDonor *ret)
/* Create a gtexDonor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexDonor */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->gender = sqlStringComma(&s);
ret->age = sqlUnsignedComma(&s);
ret->deathClass = sqlSignedComma(&s);
*pS = s;
return ret;
}

void gtexDonorFree(struct gtexDonor **pEl)
/* Free a single dynamically allocated gtexDonor such as created
 * with gtexDonorLoad(). */
{
struct gtexDonor *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->gender);
freez(pEl);
}

void gtexDonorFreeList(struct gtexDonor **pList)
/* Free a list of dynamically allocated gtexDonor's */
{
struct gtexDonor *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexDonorFree(&el);
    }
*pList = NULL;
}

void gtexDonorOutput(struct gtexDonor *el, FILE *f, char sep, char lastSep) 
/* Print out gtexDonor.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gender);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->age);
fputc(sep,f);
fprintf(f, "%d", el->deathClass);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexDonorCreateTable(struct sqlConnection *conn, char *table)
/* Create donor record format table */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    name varchar(255) not null,	# GTEX subject identifier (minus leading GTEX-), e.g. N7MS\n"
"    gender varchar(255) not null,	# Gender (M/F)\n"
"    age int unsigned not null,	# Subject age, to the decade (60 means 60-69 yrs)\n"
"    deathClass int not null,	# Hardy scale: 0=Ventilator, 1=Fast violent, 2=Fast natural, 3=Intermediate, 4=Slow.  -1 for unknown\n"
"              #Indices\n"
"    PRIMARY KEY(name)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}
