/* liftSpec.c was originally generated by the autoSql program, which also 
 * generated liftSpec.h and liftSpec.sql.  This module links the database and the RAM 
 * representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "jksql.h"
#include "liftSpec.h"


void liftSpecStaticLoad(char **row, struct liftSpec *ret)
/* Load a row from liftSpec table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->offset = sqlSigned(row[0]);
ret->oldName = row[1];
ret->oldSize = sqlSigned(row[2]);
ret->newName = row[3];
ret->size = sqlSigned(row[4]);
}

struct liftSpec *liftSpecLoad(char **row)
/* Load a liftSpec from row fetched with select * from liftSpec
 * from database.  Dispose of this with liftSpecFree(). */
{
struct liftSpec *ret;

AllocVar(ret);
ret->offset = sqlSigned(row[0]);
ret->oldName = cloneString(row[1]);
ret->oldSize = sqlSigned(row[2]);
ret->newName = cloneString(row[3]);
ret->size = sqlSigned(row[4]);
return ret;
}

struct liftSpec *liftSpecCommaIn(char **pS, struct liftSpec *ret)
/* Create a liftSpec out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new liftSpec */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->offset = sqlSignedComma(&s);
ret->oldName = sqlStringComma(&s);
ret->oldSize = sqlSignedComma(&s);
ret->newName = sqlStringComma(&s);
ret->size = sqlSignedComma(&s);
*pS = s;
return ret;
}

void liftSpecFree(struct liftSpec **pEl)
/* Free a single dynamically allocated liftSpec such as created
 * with liftSpecLoad(). */
{
struct liftSpec *el;

if ((el = *pEl) == NULL) return;
freeMem(el->oldName);
freeMem(el->newName);
freez(pEl);
}

void liftSpecFreeList(struct liftSpec **pList)
/* Free a list of dynamically allocated liftSpec's */
{
struct liftSpec *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    liftSpecFree(&el);
    }
*pList = NULL;
}

void liftSpecOutput(struct liftSpec *el, FILE *f, char sep, char lastSep) 
/* Print out liftSpec.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->offset);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->oldName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->oldSize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->newName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->size);
fputc(lastSep,f);
}

