/* exportedDataHubs.c was originally generated by the autoSql program, which also 
 * generated exportedDataHubs.h and exportedDataHubs.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hdb.h"
#include "hgConfig.h"
#include "exportedDataHubs.h"



char *exportedDataHubsCommaSepFieldNames = "id,db,label,description,path";

void exportedDataHubsStaticLoad(char **row, struct exportedDataHubs *ret)
/* Load a row from exportedDataHubs table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->db = row[1];
ret->label = row[2];
ret->description = row[3];
ret->path = row[4];
}

struct exportedDataHubs *exportedDataHubsLoad(char **row)
/* Load a exportedDataHubs from row fetched with select * from exportedDataHubs
 * from database.  Dispose of this with exportedDataHubsFree(). */
{
struct exportedDataHubs *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->db = cloneString(row[1]);
ret->label = cloneString(row[2]);
ret->description = cloneString(row[3]);
ret->path = cloneString(row[4]);
return ret;
}

struct exportedDataHubs *exportedDataHubsLoadAll(char *fileName) 
/* Load all exportedDataHubs from a whitespace-separated file.
 * Dispose of this with exportedDataHubsFreeList(). */
{
struct exportedDataHubs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = exportedDataHubsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct exportedDataHubs *exportedDataHubsLoadAllByChar(char *fileName, char chopper) 
/* Load all exportedDataHubs from a chopper separated file.
 * Dispose of this with exportedDataHubsFreeList(). */
{
struct exportedDataHubs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = exportedDataHubsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct exportedDataHubs *exportedDataHubsCommaIn(char **pS, struct exportedDataHubs *ret)
/* Create a exportedDataHubs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new exportedDataHubs */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->db = sqlStringComma(&s);
ret->label = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->path = sqlStringComma(&s);
*pS = s;
return ret;
}

void exportedDataHubsFree(struct exportedDataHubs **pEl)
/* Free a single dynamically allocated exportedDataHubs such as created
 * with exportedDataHubsLoad(). */
{
struct exportedDataHubs *el;

if ((el = *pEl) == NULL) return;
freeMem(el->db);
freeMem(el->label);
freeMem(el->description);
freeMem(el->path);
freez(pEl);
}

void exportedDataHubsFreeList(struct exportedDataHubs **pList)
/* Free a list of dynamically allocated exportedDataHubs's */
{
struct exportedDataHubs *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    exportedDataHubsFree(&el);
    }
*pList = NULL;
}

void exportedDataHubsOutput(struct exportedDataHubs *el, FILE *f, char sep, char lastSep) 
/* Print out exportedDataHubs.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->db);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->label);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->path);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

unsigned registerExportedDataHub(char *db, char *hubUrl)
/* Add a hub to the exportedDataHubs table. */
{
unsigned ret = 0;
struct sqlConnection *conn = hConnectCentral();
char query[2048];
sqlSafef(query, sizeof(query), "select id from exportedDataHubs  where db='%s' and path='%s'", db, hubUrl);
char *id = sqlQuickString(conn, query);

if (id)
    ret = atoi(id);
else
    {
    sqlSafef(query, sizeof(query), "insert into exportedDataHubs values(0, '%s', 'Private','Private Label', '%s')", db, hubUrl);
    sqlUpdate(conn, query);

    // now get the auto-increment id 
    sqlSafef(query, sizeof(query), "select id from exportedDataHubs  where db='%s' and path='%s'", db, hubUrl);
    id = sqlQuickString(conn, query);
    if (id)
        ret = atoi(id);
    }

hDisconnectCentral(&conn);

return ret;
}

boolean exportedDataHubsEnabled()
/* Return TRUE if feature is available */
{
char *cfgEnabled = cfgOption("browser.exportedDataHubs");
return cfgEnabled && (sameString(cfgEnabled, "on") || sameString(cfgEnabled, "true")) ;
}
