/* plasEndPairs.h was originally generated by the autoSql program, which also 
 * generated plasEndPairs.c and plasEndPairs.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef PLASENDPAIRS_H
#define PLASENDPAIRS_H

struct plasEndPairs
/* Standard linked features series table */
    {
    struct plasEndPairs *next;  /* Next in singly linked list. */
    short bin;	/* Bin number for browser speedup */
    char *chrom;	/* Human chromosome or FPC contig */
    unsigned chromStart;	/* Start position of clone in chromosome */
    unsigned chromEnd;	/* End position of clone in chromosome */
    char *name;	/* Name of clone */
    unsigned score;	/* Score = 1000/(# of times clone appears in assembly) */
    char strand[2];	/* Value should be + or - */
    char *pslTable;	/* Table which contains corresponding PSL records for linked features */
    unsigned lfCount;	/* Number of linked features in the series */
    unsigned *lfStarts;	/* Comma separated list of start positions of each linked feature in genomic */
    unsigned *lfSizes;	/* Comma separated list of sizes of each linked feature in genomic */
    char **lfNames;	/* Comma separated list of names of linked features */
    };

struct plasEndPairs *plasEndPairsLoad(char **row);
/* Load a plasEndPairs from row fetched with select * from plasEndPairs
 * from database.  Dispose of this with plasEndPairsFree(). */

struct plasEndPairs *plasEndPairsLoadAll(char *fileName);
/* Load all plasEndPairs from a tab-separated file.
 * Dispose of this with plasEndPairsFreeList(). */

struct plasEndPairs *plasEndPairsLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all plasEndPairs from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with plasEndPairsFreeList(). */

struct plasEndPairs *plasEndPairsCommaIn(char **pS, struct plasEndPairs *ret);
/* Create a plasEndPairs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new plasEndPairs */

void plasEndPairsFree(struct plasEndPairs **pEl);
/* Free a single dynamically allocated plasEndPairs such as created
 * with plasEndPairsLoad(). */

void plasEndPairsFreeList(struct plasEndPairs **pList);
/* Free a list of dynamically allocated plasEndPairs's */

void plasEndPairsOutput(struct plasEndPairs *el, FILE *f, char sep, char lastSep);
/* Print out plasEndPairs.  Separate fields with sep. Follow last field with lastSep. */

#define plasEndPairsTabOut(el,f) plasEndPairsOutput(el,f,'\t','\n');
/* Print out plasEndPairs as a line in a tab-separated file. */

#define plasEndPairsCommaOut(el,f) plasEndPairsOutput(el,f,',',',');
/* Print out plasEndPairs as a comma separated list including final comma. */

#endif /* PLASENDPAIRS_H */

