/* hapmapSnpsCombined.h was originally generated by the autoSql program, which also 
 * generated hapmapSnpsCombined.c and hapmapSnpsCombined.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HAPMAPSNPSCOMBINED_H
#define HAPMAPSNPSCOMBINED_H

#define HAPMAPSNPSCOMBINED_NUM_COLS 21

struct hapmapSnpsCombined
/* HapMap allele counts by population */
    {
    struct hapmapSnpsCombined *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom (0 based) */
    unsigned chromEnd;	/* End position in chrom (1 based) */
    char *name;	/* Reference SNP identifier from dbSnp */
    unsigned score;	/* Not used */
    char strand[2];	/* Which genomic strand contains the observed alleles */
    char *observed;	/* Observed string from genotype file */
    char allele1[2];	/* This allele has been observed */
    unsigned homoCount1CEU;	/* Count of CEU individuals who are homozygous for allele1 */
    unsigned homoCount1CHB;	/* Count of CHB individuals who are homozygous for allele1 */
    unsigned homoCount1JPT;	/* Count of JPT individuals who are homozygous for allele1 */
    unsigned homoCount1YRI;	/* Count of YRI individuals who are homozygous for allele1 */
    char *allele2;	/* This allele may not have been observed */
    unsigned homoCount2CEU;	/* Count of CEU individuals who are homozygous for allele2 */
    unsigned homoCount2CHB;	/* Count of CHB individuals who are homozygous for allele2 */
    unsigned homoCount2JPT;	/* Count of JPT individuals who are homozygous for allele2 */
    unsigned homoCount2YRI;	/* Count of YRI individuals who are homozygous for allele2 */
    unsigned heteroCountCEU;	/* Count of CEU individuals who are heterozygous */
    unsigned heteroCountCHB;	/* Count of CHB individuals who are heterozygous */
    unsigned heteroCountJPT;	/* Count of JPT individuals who are heterozygous */
    unsigned heteroCountYRI;	/* Count of YRI individuals who are heterozygous */
    };

void hapmapSnpsCombinedStaticLoad(char **row, struct hapmapSnpsCombined *ret);
/* Load a row from hapmapSnpsCombined table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hapmapSnpsCombined *hapmapSnpsCombinedLoad(char **row);
/* Load a hapmapSnpsCombined from row fetched with select * from hapmapSnpsCombined
 * from database.  Dispose of this with hapmapSnpsCombinedFree(). */

struct hapmapSnpsCombined *hapmapSnpsCombinedLoadAll(char *fileName);
/* Load all hapmapSnpsCombined from whitespace-separated file.
 * Dispose of this with hapmapSnpsCombinedFreeList(). */

struct hapmapSnpsCombined *hapmapSnpsCombinedLoadAllByChar(char *fileName, char chopper);
/* Load all hapmapSnpsCombined from chopper separated file.
 * Dispose of this with hapmapSnpsCombinedFreeList(). */

#define hapmapSnpsCombinedLoadAllByTab(a) hapmapSnpsCombinedLoadAllByChar(a, '\t');
/* Load all hapmapSnpsCombined from tab separated file.
 * Dispose of this with hapmapSnpsCombinedFreeList(). */

struct hapmapSnpsCombined *hapmapSnpsCombinedCommaIn(char **pS, struct hapmapSnpsCombined *ret);
/* Create a hapmapSnpsCombined out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapSnpsCombined */

void hapmapSnpsCombinedFree(struct hapmapSnpsCombined **pEl);
/* Free a single dynamically allocated hapmapSnpsCombined such as created
 * with hapmapSnpsCombinedLoad(). */

void hapmapSnpsCombinedFreeList(struct hapmapSnpsCombined **pList);
/* Free a list of dynamically allocated hapmapSnpsCombined's */

void hapmapSnpsCombinedOutput(struct hapmapSnpsCombined *el, FILE *f, char sep, char lastSep);
/* Print out hapmapSnpsCombined.  Separate fields with sep. Follow last field with lastSep. */

#define hapmapSnpsCombinedTabOut(el,f) hapmapSnpsCombinedOutput(el,f,'\t','\n');
/* Print out hapmapSnpsCombined as a line in a tab-separated file. */

#define hapmapSnpsCombinedCommaOut(el,f) hapmapSnpsCombinedOutput(el,f,',',',');
/* Print out hapmapSnpsCombined as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int getPopCount(struct hapmapSnpsCombined *thisItem);

boolean isMixed(struct hapmapSnpsCombined *thisItem);
/* return TRUE if different populations have a different major allele */

void printOne(struct hapmapSnpsCombined *thisItem);

int calcHet(struct hapmapSnpsCombined *thisItem);
/* calculate heterozygosity (2pq) */

#endif /* HAPMAPSNPSCOMBINED_H */

