/* geneCheck.h was originally generated by the autoSql program, which also 
 * generated geneCheck.c and geneCheck.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2006 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef GENECHECK_H
#define GENECHECK_H

#define GENECHECK_NUM_COLS 23

struct geneCheck
/* results from gene-check program */
    {
    struct geneCheck *next;  /* Next in singly linked list. */
    char *acc;	/* gene id or accession */
    char *chr;	/* chromosome */
    unsigned chrStart;	/* chromosome start */
    unsigned chrEnd;	/* chromosome end */
    char strand[2];	/* strand */
    char stat[5];	/* status of overall check: ok or err */
    char frame[13];	/* frame status: ok, bad, noCDS, mismatch, discontig */
    char start[3];	/* is there a start codon: ok or no */
    char stop[3];	/* is there a stop codon: ok or no */
    unsigned orfStop;	/* number of in-frame stop codons */
    unsigned cdsGap;	/* number of gaps in CDS */
    unsigned cdsMult3Gap;	/* number of CDS gaps that are a multiple of 3 */
    unsigned utrGap;	/* number of gaps in UTR */
    unsigned cdsSplice;	/* number of CDS introns with unknown splice sites */
    unsigned utrSplice;	/* number of CDS introns with unknown splice sites */
    unsigned numExons;	/* number of exons */
    unsigned numCds;	/* number of CDS exons */
    unsigned numUtr5;	/* number of 5'UTR exons */
    unsigned numUtr3;	/* number of 3'UTR exons */
    unsigned numCdsIntrons;	/* number of CDS introns */
    unsigned numUtrIntrons;	/* number of UTR introns */
    char nmd[5];	/* Is this an NMD candidate: ok or nmd */
    char *causes;	/* comma separated string with list of causes (for easy matching) */
    };

void geneCheckStaticLoad(char **row, struct geneCheck *ret);
/* Load a row from geneCheck table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct geneCheck *geneCheckLoad(char **row);
/* Load a geneCheck from row fetched with select * from geneCheck
 * from database.  Dispose of this with geneCheckFree(). */

struct geneCheck *geneCheckLoadAll(char *fileName);
/* Load all geneCheck from whitespace-separated file.
 * Dispose of this with geneCheckFreeList(). */

struct geneCheck *geneCheckLoadAllByChar(char *fileName, char chopper);
/* Load all geneCheck from chopper separated file.
 * Dispose of this with geneCheckFreeList(). */

#define geneCheckLoadAllByTab(a) geneCheckLoadAllByChar(a, '\t');
/* Load all geneCheck from tab separated file.
 * Dispose of this with geneCheckFreeList(). */

struct geneCheck *geneCheckCommaIn(char **pS, struct geneCheck *ret);
/* Create a geneCheck out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneCheck */

void geneCheckFree(struct geneCheck **pEl);
/* Free a single dynamically allocated geneCheck such as created
 * with geneCheckLoad(). */

void geneCheckFreeList(struct geneCheck **pList);
/* Free a list of dynamically allocated geneCheck's */

void geneCheckOutput(struct geneCheck *el, FILE *f, char sep, char lastSep);
/* Print out geneCheck.  Separate fields with sep. Follow last field with lastSep. */

#define geneCheckTabOut(el,f) geneCheckOutput(el,f,'\t','\n');
/* Print out geneCheck as a line in a tab-separated file. */

#define geneCheckCommaOut(el,f) geneCheckOutput(el,f,',',',');
/* Print out geneCheck as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GENECHECK_H */

