/* estPair.h was originally generated by the autoSql program, which also 
 * generated estPair.c and estPair.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ESTPAIR_H
#define ESTPAIR_H

struct estPair
/* EST 5'- 3' pairing information */
    {
    struct estPair *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome name */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *mrnaClone;	/* Mrna clone name */
    char *acc5;	/* 5' EST accession number */
    unsigned start5;	/* Start position of 5' EST in chromosome */
    unsigned end5;	/* End position of 5' EST in chromosome */
    char *acc3;	/* 3' EST accession number */
    unsigned start3;	/* Start position of 3' EST in chromosome */
    unsigned end3;	/* End position of 3' EST in chromosome */
    };

void estPairStaticLoad(char **row, struct estPair *ret);
/* Load a row from estPair table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct estPair *estPairLoad(char **row);
/* Load a estPair from row fetched with select * from estPair
 * from database.  Dispose of this with estPairFree(). */

struct estPair *estPairLoadAll(char *fileName);
/* Load all estPair from a tab-separated file.
 * Dispose of this with estPairFreeList(). */

struct estPair *estPairCommaIn(char **pS, struct estPair *ret);
/* Create a estPair out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new estPair */

void estPairFree(struct estPair **pEl);
/* Free a single dynamically allocated estPair such as created
 * with estPairLoad(). */

void estPairFreeList(struct estPair **pList);
/* Free a list of dynamically allocated estPair's */

void estPairOutput(struct estPair *el, FILE *f, char sep, char lastSep);
/* Print out estPair.  Separate fields with sep. Follow last field with lastSep. */

#define estPairTabOut(el,f) estPairOutput(el,f,'\t','\n');
/* Print out estPair as a line in a tab-separated file. */

#define estPairCommaOut(el,f) estPairOutput(el,f,',',',');
/* Print out estPair as a comma separated list including final comma. */

#endif /* ESTPAIR_H */

