/* encodeDataWarehouse.c was originally generated by the autoSql program, which also 
 * generated encodeDataWarehouse.h and encodeDataWarehouse.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encodeDataWarehouse.h"



char *edwSettingsCommaSepFieldNames = "id,name,val";

void edwSettingsStaticLoad(char **row, struct edwSettings *ret)
/* Load a row from edwSettings table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->val = row[2];
}

struct edwSettings *edwSettingsLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwSettings from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSettingsFreeList(). */
{
struct edwSettings *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwSettingsLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwSettingsSaveToDb(struct sqlConnection *conn, struct edwSettings *el, char *tableName, int updateSize)
/* Save edwSettings as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s')", 
	tableName,  el->id,  el->name,  el->val);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwSettings *edwSettingsLoad(char **row)
/* Load a edwSettings from row fetched with select * from edwSettings
 * from database.  Dispose of this with edwSettingsFree(). */
{
struct edwSettings *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->val = cloneString(row[2]);
return ret;
}

struct edwSettings *edwSettingsLoadAll(char *fileName) 
/* Load all edwSettings from a whitespace-separated file.
 * Dispose of this with edwSettingsFreeList(). */
{
struct edwSettings *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = edwSettingsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSettings *edwSettingsLoadAllByChar(char *fileName, char chopper) 
/* Load all edwSettings from a chopper separated file.
 * Dispose of this with edwSettingsFreeList(). */
{
struct edwSettings *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwSettingsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSettings *edwSettingsCommaIn(char **pS, struct edwSettings *ret)
/* Create a edwSettings out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSettings */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->val = sqlStringComma(&s);
*pS = s;
return ret;
}

void edwSettingsFree(struct edwSettings **pEl)
/* Free a single dynamically allocated edwSettings such as created
 * with edwSettingsLoad(). */
{
struct edwSettings *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->val);
freez(pEl);
}

void edwSettingsFreeList(struct edwSettings **pList)
/* Free a list of dynamically allocated edwSettings's */
{
struct edwSettings *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwSettingsFree(&el);
    }
*pList = NULL;
}

void edwSettingsOutput(struct edwSettings *el, FILE *f, char sep, char lastSep) 
/* Print out edwSettings.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->val);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *edwUserCommaSepFieldNames = "id,email,uuid,isAdmin";

void edwUserStaticLoad(char **row, struct edwUser *ret)
/* Load a row from edwUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->email = row[1];
safecpy(ret->uuid, sizeof(ret->uuid), row[2]);
ret->isAdmin = sqlSigned(row[3]);
}

struct edwUser *edwUserLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwUserFreeList(). */
{
struct edwUser *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwUserLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwUserSaveToDb(struct sqlConnection *conn, struct edwUser *el, char *tableName, int updateSize)
/* Save edwUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s',%d)", 
	tableName,  el->id,  el->email,  el->uuid,  el->isAdmin);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwUser *edwUserLoad(char **row)
/* Load a edwUser from row fetched with select * from edwUser
 * from database.  Dispose of this with edwUserFree(). */
{
struct edwUser *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->email = cloneString(row[1]);
safecpy(ret->uuid, sizeof(ret->uuid), row[2]);
ret->isAdmin = sqlSigned(row[3]);
return ret;
}

struct edwUser *edwUserLoadAll(char *fileName) 
/* Load all edwUser from a whitespace-separated file.
 * Dispose of this with edwUserFreeList(). */
{
struct edwUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = edwUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwUser *edwUserLoadAllByChar(char *fileName, char chopper) 
/* Load all edwUser from a chopper separated file.
 * Dispose of this with edwUserFreeList(). */
{
struct edwUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwUser *edwUserCommaIn(char **pS, struct edwUser *ret)
/* Create a edwUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwUser */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->email = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->uuid, sizeof(ret->uuid));
ret->isAdmin = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwUserFree(struct edwUser **pEl)
/* Free a single dynamically allocated edwUser such as created
 * with edwUserLoad(). */
{
struct edwUser *el;

if ((el = *pEl) == NULL) return;
freeMem(el->email);
freez(pEl);
}

void edwUserFreeList(struct edwUser **pList)
/* Free a list of dynamically allocated edwUser's */
{
struct edwUser *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwUserFree(&el);
    }
*pList = NULL;
}

void edwUserOutput(struct edwUser *el, FILE *f, char sep, char lastSep) 
/* Print out edwUser.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->email);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->uuid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->isAdmin);
fputc(lastSep,f);
}


char *edwScriptRegistryCommaSepFieldNames = "id,userId,name,description,secretHash,submitCount";

void edwScriptRegistryStaticLoad(char **row, struct edwScriptRegistry *ret)
/* Load a row from edwScriptRegistry table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->userId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->description = row[3];
ret->secretHash = row[4];
ret->submitCount = sqlSigned(row[5]);
}

struct edwScriptRegistry *edwScriptRegistryLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwScriptRegistry from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwScriptRegistryFreeList(). */
{
struct edwScriptRegistry *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwScriptRegistrySaveToDb(struct sqlConnection *conn, struct edwScriptRegistry *el, char *tableName, int updateSize)
/* Save edwScriptRegistry as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s','%s',%d)", 
	tableName,  el->id,  el->userId,  el->name,  el->description,  el->secretHash,  el->submitCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwScriptRegistry *edwScriptRegistryLoad(char **row)
/* Load a edwScriptRegistry from row fetched with select * from edwScriptRegistry
 * from database.  Dispose of this with edwScriptRegistryFree(). */
{
struct edwScriptRegistry *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->userId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->description = cloneString(row[3]);
ret->secretHash = cloneString(row[4]);
ret->submitCount = sqlSigned(row[5]);
return ret;
}

struct edwScriptRegistry *edwScriptRegistryLoadAll(char *fileName) 
/* Load all edwScriptRegistry from a whitespace-separated file.
 * Dispose of this with edwScriptRegistryFreeList(). */
{
struct edwScriptRegistry *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = edwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwScriptRegistry *edwScriptRegistryLoadAllByChar(char *fileName, char chopper) 
/* Load all edwScriptRegistry from a chopper separated file.
 * Dispose of this with edwScriptRegistryFreeList(). */
{
struct edwScriptRegistry *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwScriptRegistry *edwScriptRegistryCommaIn(char **pS, struct edwScriptRegistry *ret)
/* Create a edwScriptRegistry out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwScriptRegistry */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->userId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->secretHash = sqlStringComma(&s);
ret->submitCount = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwScriptRegistryFree(struct edwScriptRegistry **pEl)
/* Free a single dynamically allocated edwScriptRegistry such as created
 * with edwScriptRegistryLoad(). */
{
struct edwScriptRegistry *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freeMem(el->secretHash);
freez(pEl);
}

void edwScriptRegistryFreeList(struct edwScriptRegistry **pList)
/* Free a list of dynamically allocated edwScriptRegistry's */
{
struct edwScriptRegistry *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwScriptRegistryFree(&el);
    }
*pList = NULL;
}

void edwScriptRegistryOutput(struct edwScriptRegistry *el, FILE *f, char sep, char lastSep) 
/* Print out edwScriptRegistry.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->userId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->secretHash);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->submitCount);
fputc(lastSep,f);
}


char *edwHostCommaSepFieldNames = "id,name,lastOkTime,lastNotOkTime,firstAdded,errorMessage,openSuccesses,openFails,historyBits,paraFetchStreams";

void edwHostStaticLoad(char **row, struct edwHost *ret)
/* Load a row from edwHost table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->lastOkTime = sqlLongLong(row[2]);
ret->lastNotOkTime = sqlLongLong(row[3]);
ret->firstAdded = sqlLongLong(row[4]);
ret->errorMessage = row[5];
ret->openSuccesses = sqlLongLong(row[6]);
ret->openFails = sqlLongLong(row[7]);
ret->historyBits = sqlLongLong(row[8]);
ret->paraFetchStreams = sqlSigned(row[9]);
}

struct edwHost *edwHostLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwHost from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwHostFreeList(). */
{
struct edwHost *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwHostLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwHostSaveToDb(struct sqlConnection *conn, struct edwHost *el, char *tableName, int updateSize)
/* Save edwHost as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,%lld,'%s',%lld,%lld,%lld,%d)", 
	tableName,  el->id,  el->name,  el->lastOkTime,  el->lastNotOkTime,  el->firstAdded,  el->errorMessage,  el->openSuccesses,  el->openFails,  el->historyBits,  el->paraFetchStreams);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwHost *edwHostLoad(char **row)
/* Load a edwHost from row fetched with select * from edwHost
 * from database.  Dispose of this with edwHostFree(). */
{
struct edwHost *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->lastOkTime = sqlLongLong(row[2]);
ret->lastNotOkTime = sqlLongLong(row[3]);
ret->firstAdded = sqlLongLong(row[4]);
ret->errorMessage = cloneString(row[5]);
ret->openSuccesses = sqlLongLong(row[6]);
ret->openFails = sqlLongLong(row[7]);
ret->historyBits = sqlLongLong(row[8]);
ret->paraFetchStreams = sqlSigned(row[9]);
return ret;
}

struct edwHost *edwHostLoadAll(char *fileName) 
/* Load all edwHost from a whitespace-separated file.
 * Dispose of this with edwHostFreeList(). */
{
struct edwHost *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = edwHostLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwHost *edwHostLoadAllByChar(char *fileName, char chopper) 
/* Load all edwHost from a chopper separated file.
 * Dispose of this with edwHostFreeList(). */
{
struct edwHost *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwHostLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwHost *edwHostCommaIn(char **pS, struct edwHost *ret)
/* Create a edwHost out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwHost */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->lastOkTime = sqlLongLongComma(&s);
ret->lastNotOkTime = sqlLongLongComma(&s);
ret->firstAdded = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->openSuccesses = sqlLongLongComma(&s);
ret->openFails = sqlLongLongComma(&s);
ret->historyBits = sqlLongLongComma(&s);
ret->paraFetchStreams = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwHostFree(struct edwHost **pEl)
/* Free a single dynamically allocated edwHost such as created
 * with edwHostLoad(). */
{
struct edwHost *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->errorMessage);
freez(pEl);
}

void edwHostFreeList(struct edwHost **pList)
/* Free a list of dynamically allocated edwHost's */
{
struct edwHost *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwHostFree(&el);
    }
*pList = NULL;
}

void edwHostOutput(struct edwHost *el, FILE *f, char sep, char lastSep) 
/* Print out edwHost.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->lastOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->lastNotOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->firstAdded);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->openSuccesses);
fputc(sep,f);
fprintf(f, "%lld", el->openFails);
fputc(sep,f);
fprintf(f, "%lld", el->historyBits);
fputc(sep,f);
fprintf(f, "%d", el->paraFetchStreams);
fputc(lastSep,f);
}


char *edwSubmitDirCommaSepFieldNames = "id,url,hostId,lastOkTime,lastNotOkTime,firstAdded,errorMessage,openSuccesses,openFails,historyBits";

void edwSubmitDirStaticLoad(char **row, struct edwSubmitDir *ret)
/* Load a row from edwSubmitDir table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->url = row[1];
ret->hostId = sqlUnsigned(row[2]);
ret->lastOkTime = sqlLongLong(row[3]);
ret->lastNotOkTime = sqlLongLong(row[4]);
ret->firstAdded = sqlLongLong(row[5]);
ret->errorMessage = row[6];
ret->openSuccesses = sqlLongLong(row[7]);
ret->openFails = sqlLongLong(row[8]);
ret->historyBits = sqlLongLong(row[9]);
}

struct edwSubmitDir *edwSubmitDirLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwSubmitDir from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitDirFreeList(). */
{
struct edwSubmitDir *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwSubmitDirSaveToDb(struct sqlConnection *conn, struct edwSubmitDir *el, char *tableName, int updateSize)
/* Save edwSubmitDir as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%lld,%lld,%lld,'%s',%lld,%lld,%lld)", 
	tableName,  el->id,  el->url,  el->hostId,  el->lastOkTime,  el->lastNotOkTime,  el->firstAdded,  el->errorMessage,  el->openSuccesses,  el->openFails,  el->historyBits);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwSubmitDir *edwSubmitDirLoad(char **row)
/* Load a edwSubmitDir from row fetched with select * from edwSubmitDir
 * from database.  Dispose of this with edwSubmitDirFree(). */
{
struct edwSubmitDir *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->url = cloneString(row[1]);
ret->hostId = sqlUnsigned(row[2]);
ret->lastOkTime = sqlLongLong(row[3]);
ret->lastNotOkTime = sqlLongLong(row[4]);
ret->firstAdded = sqlLongLong(row[5]);
ret->errorMessage = cloneString(row[6]);
ret->openSuccesses = sqlLongLong(row[7]);
ret->openFails = sqlLongLong(row[8]);
ret->historyBits = sqlLongLong(row[9]);
return ret;
}

struct edwSubmitDir *edwSubmitDirLoadAll(char *fileName) 
/* Load all edwSubmitDir from a whitespace-separated file.
 * Dispose of this with edwSubmitDirFreeList(). */
{
struct edwSubmitDir *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = edwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmitDir *edwSubmitDirLoadAllByChar(char *fileName, char chopper) 
/* Load all edwSubmitDir from a chopper separated file.
 * Dispose of this with edwSubmitDirFreeList(). */
{
struct edwSubmitDir *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmitDir *edwSubmitDirCommaIn(char **pS, struct edwSubmitDir *ret)
/* Create a edwSubmitDir out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmitDir */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->url = sqlStringComma(&s);
ret->hostId = sqlUnsignedComma(&s);
ret->lastOkTime = sqlLongLongComma(&s);
ret->lastNotOkTime = sqlLongLongComma(&s);
ret->firstAdded = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->openSuccesses = sqlLongLongComma(&s);
ret->openFails = sqlLongLongComma(&s);
ret->historyBits = sqlLongLongComma(&s);
*pS = s;
return ret;
}

void edwSubmitDirFree(struct edwSubmitDir **pEl)
/* Free a single dynamically allocated edwSubmitDir such as created
 * with edwSubmitDirLoad(). */
{
struct edwSubmitDir *el;

if ((el = *pEl) == NULL) return;
freeMem(el->url);
freeMem(el->errorMessage);
freez(pEl);
}

void edwSubmitDirFreeList(struct edwSubmitDir **pList)
/* Free a list of dynamically allocated edwSubmitDir's */
{
struct edwSubmitDir *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwSubmitDirFree(&el);
    }
*pList = NULL;
}

void edwSubmitDirOutput(struct edwSubmitDir *el, FILE *f, char sep, char lastSep) 
/* Print out edwSubmitDir.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->hostId);
fputc(sep,f);
fprintf(f, "%lld", el->lastOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->lastNotOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->firstAdded);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->openSuccesses);
fputc(sep,f);
fprintf(f, "%lld", el->openFails);
fputc(sep,f);
fprintf(f, "%lld", el->historyBits);
fputc(lastSep,f);
}


char *edwFileCommaSepFieldNames = "id,submitId,submitDirId,submitFileName,edwFileName,startUploadTime,endUploadTime,updateTime,size,md5,tags,errorMessage,deprecated,replacedBy";

void edwFileStaticLoad(char **row, struct edwFile *ret)
/* Load a row from edwFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->submitId = sqlUnsigned(row[1]);
ret->submitDirId = sqlUnsigned(row[2]);
ret->submitFileName = row[3];
ret->edwFileName = row[4];
ret->startUploadTime = sqlLongLong(row[5]);
ret->endUploadTime = sqlLongLong(row[6]);
ret->updateTime = sqlLongLong(row[7]);
ret->size = sqlLongLong(row[8]);
safecpy(ret->md5, sizeof(ret->md5), row[9]);
ret->tags = row[10];
ret->errorMessage = row[11];
ret->deprecated = row[12];
ret->replacedBy = sqlUnsigned(row[13]);
}

struct edwFile *edwFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwFileFreeList(). */
{
struct edwFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwFileSaveToDb(struct sqlConnection *conn, struct edwFile *el, char *tableName, int updateSize)
/* Save edwFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,'%s','%s',%lld,%lld,%lld,%lld,'%s','%s','%s','%s',%u)", 
	tableName,  el->id,  el->submitId,  el->submitDirId,  el->submitFileName,  el->edwFileName,  el->startUploadTime,  el->endUploadTime,  el->updateTime,  el->size,  el->md5,  el->tags,  el->errorMessage,  el->deprecated,  el->replacedBy);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwFile *edwFileLoad(char **row)
/* Load a edwFile from row fetched with select * from edwFile
 * from database.  Dispose of this with edwFileFree(). */
{
struct edwFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->submitId = sqlUnsigned(row[1]);
ret->submitDirId = sqlUnsigned(row[2]);
ret->submitFileName = cloneString(row[3]);
ret->edwFileName = cloneString(row[4]);
ret->startUploadTime = sqlLongLong(row[5]);
ret->endUploadTime = sqlLongLong(row[6]);
ret->updateTime = sqlLongLong(row[7]);
ret->size = sqlLongLong(row[8]);
safecpy(ret->md5, sizeof(ret->md5), row[9]);
ret->tags = cloneString(row[10]);
ret->errorMessage = cloneString(row[11]);
ret->deprecated = cloneString(row[12]);
ret->replacedBy = sqlUnsigned(row[13]);
return ret;
}

struct edwFile *edwFileLoadAll(char *fileName) 
/* Load all edwFile from a whitespace-separated file.
 * Dispose of this with edwFileFreeList(). */
{
struct edwFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = edwFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwFile *edwFileLoadAllByChar(char *fileName, char chopper) 
/* Load all edwFile from a chopper separated file.
 * Dispose of this with edwFileFreeList(). */
{
struct edwFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwFile *edwFileCommaIn(char **pS, struct edwFile *ret)
/* Create a edwFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->submitId = sqlUnsignedComma(&s);
ret->submitDirId = sqlUnsignedComma(&s);
ret->submitFileName = sqlStringComma(&s);
ret->edwFileName = sqlStringComma(&s);
ret->startUploadTime = sqlLongLongComma(&s);
ret->endUploadTime = sqlLongLongComma(&s);
ret->updateTime = sqlLongLongComma(&s);
ret->size = sqlLongLongComma(&s);
sqlFixedStringComma(&s, ret->md5, sizeof(ret->md5));
ret->tags = sqlStringComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->deprecated = sqlStringComma(&s);
ret->replacedBy = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void edwFileFree(struct edwFile **pEl)
/* Free a single dynamically allocated edwFile such as created
 * with edwFileLoad(). */
{
struct edwFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->submitFileName);
freeMem(el->edwFileName);
freeMem(el->tags);
freeMem(el->errorMessage);
freeMem(el->deprecated);
freez(pEl);
}

void edwFileFreeList(struct edwFile **pList)
/* Free a list of dynamically allocated edwFile's */
{
struct edwFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwFileFree(&el);
    }
*pList = NULL;
}

void edwFileOutput(struct edwFile *el, FILE *f, char sep, char lastSep) 
/* Print out edwFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->submitId);
fputc(sep,f);
fprintf(f, "%u", el->submitDirId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->submitFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->edwFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->endUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->updateTime);
fputc(sep,f);
fprintf(f, "%lld", el->size);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->md5);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tags);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->deprecated);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->replacedBy);
fputc(lastSep,f);
}


char *edwSubmitCommaSepFieldNames = "id,url,startUploadTime,endUploadTime,userId,submitFileId,submitDirId,fileCount,oldFiles,newFiles,byteCount,oldBytes,newBytes,errorMessage,fileIdInTransit,metaChangeCount";

void edwSubmitStaticLoad(char **row, struct edwSubmit *ret)
/* Load a row from edwSubmit table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->url = row[1];
ret->startUploadTime = sqlLongLong(row[2]);
ret->endUploadTime = sqlLongLong(row[3]);
ret->userId = sqlUnsigned(row[4]);
ret->submitFileId = sqlUnsigned(row[5]);
ret->submitDirId = sqlUnsigned(row[6]);
ret->fileCount = sqlUnsigned(row[7]);
ret->oldFiles = sqlUnsigned(row[8]);
ret->newFiles = sqlUnsigned(row[9]);
ret->byteCount = sqlLongLong(row[10]);
ret->oldBytes = sqlLongLong(row[11]);
ret->newBytes = sqlLongLong(row[12]);
ret->errorMessage = row[13];
ret->fileIdInTransit = sqlUnsigned(row[14]);
ret->metaChangeCount = sqlUnsigned(row[15]);
}

struct edwSubmit *edwSubmitLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwSubmit from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitFreeList(). */
{
struct edwSubmit *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwSubmitLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwSubmitSaveToDb(struct sqlConnection *conn, struct edwSubmit *el, char *tableName, int updateSize)
/* Save edwSubmit as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,%u,%u,%u,%u,%u,%u,%lld,%lld,%lld,'%s',%u,%u)", 
	tableName,  el->id,  el->url,  el->startUploadTime,  el->endUploadTime,  el->userId,  el->submitFileId,  el->submitDirId,  el->fileCount,  el->oldFiles,  el->newFiles,  el->byteCount,  el->oldBytes,  el->newBytes,  el->errorMessage,  el->fileIdInTransit,  el->metaChangeCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwSubmit *edwSubmitLoad(char **row)
/* Load a edwSubmit from row fetched with select * from edwSubmit
 * from database.  Dispose of this with edwSubmitFree(). */
{
struct edwSubmit *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->url = cloneString(row[1]);
ret->startUploadTime = sqlLongLong(row[2]);
ret->endUploadTime = sqlLongLong(row[3]);
ret->userId = sqlUnsigned(row[4]);
ret->submitFileId = sqlUnsigned(row[5]);
ret->submitDirId = sqlUnsigned(row[6]);
ret->fileCount = sqlUnsigned(row[7]);
ret->oldFiles = sqlUnsigned(row[8]);
ret->newFiles = sqlUnsigned(row[9]);
ret->byteCount = sqlLongLong(row[10]);
ret->oldBytes = sqlLongLong(row[11]);
ret->newBytes = sqlLongLong(row[12]);
ret->errorMessage = cloneString(row[13]);
ret->fileIdInTransit = sqlUnsigned(row[14]);
ret->metaChangeCount = sqlUnsigned(row[15]);
return ret;
}

struct edwSubmit *edwSubmitLoadAll(char *fileName) 
/* Load all edwSubmit from a whitespace-separated file.
 * Dispose of this with edwSubmitFreeList(). */
{
struct edwSubmit *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[16];

while (lineFileRow(lf, row))
    {
    el = edwSubmitLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmit *edwSubmitLoadAllByChar(char *fileName, char chopper) 
/* Load all edwSubmit from a chopper separated file.
 * Dispose of this with edwSubmitFreeList(). */
{
struct edwSubmit *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[16];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwSubmitLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmit *edwSubmitCommaIn(char **pS, struct edwSubmit *ret)
/* Create a edwSubmit out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmit */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->url = sqlStringComma(&s);
ret->startUploadTime = sqlLongLongComma(&s);
ret->endUploadTime = sqlLongLongComma(&s);
ret->userId = sqlUnsignedComma(&s);
ret->submitFileId = sqlUnsignedComma(&s);
ret->submitDirId = sqlUnsignedComma(&s);
ret->fileCount = sqlUnsignedComma(&s);
ret->oldFiles = sqlUnsignedComma(&s);
ret->newFiles = sqlUnsignedComma(&s);
ret->byteCount = sqlLongLongComma(&s);
ret->oldBytes = sqlLongLongComma(&s);
ret->newBytes = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->fileIdInTransit = sqlUnsignedComma(&s);
ret->metaChangeCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void edwSubmitFree(struct edwSubmit **pEl)
/* Free a single dynamically allocated edwSubmit such as created
 * with edwSubmitLoad(). */
{
struct edwSubmit *el;

if ((el = *pEl) == NULL) return;
freeMem(el->url);
freeMem(el->errorMessage);
freez(pEl);
}

void edwSubmitFreeList(struct edwSubmit **pList)
/* Free a list of dynamically allocated edwSubmit's */
{
struct edwSubmit *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwSubmitFree(&el);
    }
*pList = NULL;
}

void edwSubmitOutput(struct edwSubmit *el, FILE *f, char sep, char lastSep) 
/* Print out edwSubmit.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->endUploadTime);
fputc(sep,f);
fprintf(f, "%u", el->userId);
fputc(sep,f);
fprintf(f, "%u", el->submitFileId);
fputc(sep,f);
fprintf(f, "%u", el->submitDirId);
fputc(sep,f);
fprintf(f, "%u", el->fileCount);
fputc(sep,f);
fprintf(f, "%u", el->oldFiles);
fputc(sep,f);
fprintf(f, "%u", el->newFiles);
fputc(sep,f);
fprintf(f, "%lld", el->byteCount);
fputc(sep,f);
fprintf(f, "%lld", el->oldBytes);
fputc(sep,f);
fprintf(f, "%lld", el->newBytes);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileIdInTransit);
fputc(sep,f);
fprintf(f, "%u", el->metaChangeCount);
fputc(lastSep,f);
}


char *edwSubscriberCommaSepFieldNames = "id,name,runOrder,filePattern,dirPattern,tagPattern,onFileEndUpload";

void edwSubscriberStaticLoad(char **row, struct edwSubscriber *ret)
/* Load a row from edwSubscriber table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->runOrder = sqlDouble(row[2]);
ret->filePattern = row[3];
ret->dirPattern = row[4];
ret->tagPattern = row[5];
ret->onFileEndUpload = row[6];
}

struct edwSubscriber *edwSubscriberLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwSubscriber from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubscriberFreeList(). */
{
struct edwSubscriber *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwSubscriberLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwSubscriberSaveToDb(struct sqlConnection *conn, struct edwSubscriber *el, char *tableName, int updateSize)
/* Save edwSubscriber as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%g,'%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->runOrder,  el->filePattern,  el->dirPattern,  el->tagPattern,  el->onFileEndUpload);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwSubscriber *edwSubscriberLoad(char **row)
/* Load a edwSubscriber from row fetched with select * from edwSubscriber
 * from database.  Dispose of this with edwSubscriberFree(). */
{
struct edwSubscriber *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->runOrder = sqlDouble(row[2]);
ret->filePattern = cloneString(row[3]);
ret->dirPattern = cloneString(row[4]);
ret->tagPattern = cloneString(row[5]);
ret->onFileEndUpload = cloneString(row[6]);
return ret;
}

struct edwSubscriber *edwSubscriberLoadAll(char *fileName) 
/* Load all edwSubscriber from a whitespace-separated file.
 * Dispose of this with edwSubscriberFreeList(). */
{
struct edwSubscriber *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = edwSubscriberLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubscriber *edwSubscriberLoadAllByChar(char *fileName, char chopper) 
/* Load all edwSubscriber from a chopper separated file.
 * Dispose of this with edwSubscriberFreeList(). */
{
struct edwSubscriber *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwSubscriberLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubscriber *edwSubscriberCommaIn(char **pS, struct edwSubscriber *ret)
/* Create a edwSubscriber out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubscriber */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->runOrder = sqlDoubleComma(&s);
ret->filePattern = sqlStringComma(&s);
ret->dirPattern = sqlStringComma(&s);
ret->tagPattern = sqlStringComma(&s);
ret->onFileEndUpload = sqlStringComma(&s);
*pS = s;
return ret;
}

void edwSubscriberFree(struct edwSubscriber **pEl)
/* Free a single dynamically allocated edwSubscriber such as created
 * with edwSubscriberLoad(). */
{
struct edwSubscriber *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->filePattern);
freeMem(el->dirPattern);
freeMem(el->tagPattern);
freeMem(el->onFileEndUpload);
freez(pEl);
}

void edwSubscriberFreeList(struct edwSubscriber **pList)
/* Free a list of dynamically allocated edwSubscriber's */
{
struct edwSubscriber *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwSubscriberFree(&el);
    }
*pList = NULL;
}

void edwSubscriberOutput(struct edwSubscriber *el, FILE *f, char sep, char lastSep) 
/* Print out edwSubscriber.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->runOrder);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->filePattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dirPattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tagPattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->onFileEndUpload);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *edwAssemblyCommaSepFieldNames = "id,taxon,name,ucscDb,twoBitId,baseCount,realBaseCount,seqCount";

void edwAssemblyStaticLoad(char **row, struct edwAssembly *ret)
/* Load a row from edwAssembly table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->taxon = sqlUnsigned(row[1]);
ret->name = row[2];
ret->ucscDb = row[3];
ret->twoBitId = sqlUnsigned(row[4]);
ret->baseCount = sqlLongLong(row[5]);
ret->realBaseCount = sqlLongLong(row[6]);
ret->seqCount = sqlUnsigned(row[7]);
}

struct edwAssembly *edwAssemblyLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwAssembly from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwAssemblyFreeList(). */
{
struct edwAssembly *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwAssemblyLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwAssemblySaveToDb(struct sqlConnection *conn, struct edwAssembly *el, char *tableName, int updateSize)
/* Save edwAssembly as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s',%u,%lld,%lld,%u)", 
	tableName,  el->id,  el->taxon,  el->name,  el->ucscDb,  el->twoBitId,  el->baseCount,  el->realBaseCount,  el->seqCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwAssembly *edwAssemblyLoad(char **row)
/* Load a edwAssembly from row fetched with select * from edwAssembly
 * from database.  Dispose of this with edwAssemblyFree(). */
{
struct edwAssembly *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->taxon = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->ucscDb = cloneString(row[3]);
ret->twoBitId = sqlUnsigned(row[4]);
ret->baseCount = sqlLongLong(row[5]);
ret->realBaseCount = sqlLongLong(row[6]);
ret->seqCount = sqlUnsigned(row[7]);
return ret;
}

struct edwAssembly *edwAssemblyLoadAll(char *fileName) 
/* Load all edwAssembly from a whitespace-separated file.
 * Dispose of this with edwAssemblyFreeList(). */
{
struct edwAssembly *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = edwAssemblyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwAssembly *edwAssemblyLoadAllByChar(char *fileName, char chopper) 
/* Load all edwAssembly from a chopper separated file.
 * Dispose of this with edwAssemblyFreeList(). */
{
struct edwAssembly *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwAssemblyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwAssembly *edwAssemblyCommaIn(char **pS, struct edwAssembly *ret)
/* Create a edwAssembly out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwAssembly */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->taxon = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->ucscDb = sqlStringComma(&s);
ret->twoBitId = sqlUnsignedComma(&s);
ret->baseCount = sqlLongLongComma(&s);
ret->realBaseCount = sqlLongLongComma(&s);
ret->seqCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void edwAssemblyFree(struct edwAssembly **pEl)
/* Free a single dynamically allocated edwAssembly such as created
 * with edwAssemblyLoad(). */
{
struct edwAssembly *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->ucscDb);
freez(pEl);
}

void edwAssemblyFreeList(struct edwAssembly **pList)
/* Free a list of dynamically allocated edwAssembly's */
{
struct edwAssembly *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwAssemblyFree(&el);
    }
*pList = NULL;
}

void edwAssemblyOutput(struct edwAssembly *el, FILE *f, char sep, char lastSep) 
/* Print out edwAssembly.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ucscDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->twoBitId);
fputc(sep,f);
fprintf(f, "%lld", el->baseCount);
fputc(sep,f);
fprintf(f, "%lld", el->realBaseCount);
fputc(sep,f);
fprintf(f, "%u", el->seqCount);
fputc(lastSep,f);
}


char *edwBiosampleCommaSepFieldNames = "id,term,taxon,sex";

void edwBiosampleStaticLoad(char **row, struct edwBiosample *ret)
/* Load a row from edwBiosample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->term = row[1];
ret->taxon = sqlUnsigned(row[2]);
ret->sex = row[3];
}

struct edwBiosample *edwBiosampleLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwBiosample from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwBiosampleFreeList(). */
{
struct edwBiosample *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwBiosampleLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwBiosampleSaveToDb(struct sqlConnection *conn, struct edwBiosample *el, char *tableName, int updateSize)
/* Save edwBiosample as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,'%s')", 
	tableName,  el->id,  el->term,  el->taxon,  el->sex);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwBiosample *edwBiosampleLoad(char **row)
/* Load a edwBiosample from row fetched with select * from edwBiosample
 * from database.  Dispose of this with edwBiosampleFree(). */
{
struct edwBiosample *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->term = cloneString(row[1]);
ret->taxon = sqlUnsigned(row[2]);
ret->sex = cloneString(row[3]);
return ret;
}

struct edwBiosample *edwBiosampleLoadAll(char *fileName) 
/* Load all edwBiosample from a whitespace-separated file.
 * Dispose of this with edwBiosampleFreeList(). */
{
struct edwBiosample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = edwBiosampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwBiosample *edwBiosampleLoadAllByChar(char *fileName, char chopper) 
/* Load all edwBiosample from a chopper separated file.
 * Dispose of this with edwBiosampleFreeList(). */
{
struct edwBiosample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwBiosampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwBiosample *edwBiosampleCommaIn(char **pS, struct edwBiosample *ret)
/* Create a edwBiosample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwBiosample */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->term = sqlStringComma(&s);
ret->taxon = sqlUnsignedComma(&s);
ret->sex = sqlStringComma(&s);
*pS = s;
return ret;
}

void edwBiosampleFree(struct edwBiosample **pEl)
/* Free a single dynamically allocated edwBiosample such as created
 * with edwBiosampleLoad(). */
{
struct edwBiosample *el;

if ((el = *pEl) == NULL) return;
freeMem(el->term);
freeMem(el->sex);
freez(pEl);
}

void edwBiosampleFreeList(struct edwBiosample **pList)
/* Free a list of dynamically allocated edwBiosample's */
{
struct edwBiosample *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwBiosampleFree(&el);
    }
*pList = NULL;
}

void edwBiosampleOutput(struct edwBiosample *el, FILE *f, char sep, char lastSep) 
/* Print out edwBiosample.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->term);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sex);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *edwExperimentCommaSepFieldNames = "accession,dataType,lab,biosample,rfa,assayType,ipTarget,control";

void edwExperimentStaticLoad(char **row, struct edwExperiment *ret)
/* Load a row from edwExperiment table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

safecpy(ret->accession, sizeof(ret->accession), row[0]);
ret->dataType = row[1];
ret->lab = row[2];
ret->biosample = row[3];
ret->rfa = row[4];
ret->assayType = row[5];
ret->ipTarget = row[6];
ret->control = row[7];
}

struct edwExperiment *edwExperimentLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwExperiment from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwExperimentFreeList(). */
{
struct edwExperiment *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwExperimentLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwExperimentSaveToDb(struct sqlConnection *conn, struct edwExperiment *el, char *tableName, int updateSize)
/* Save edwExperiment as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s','%s','%s','%s','%s','%s','%s')", 
	tableName,  el->accession,  el->dataType,  el->lab,  el->biosample,  el->rfa,  el->assayType,  el->ipTarget,  el->control);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwExperiment *edwExperimentLoad(char **row)
/* Load a edwExperiment from row fetched with select * from edwExperiment
 * from database.  Dispose of this with edwExperimentFree(). */
{
struct edwExperiment *ret;

AllocVar(ret);
safecpy(ret->accession, sizeof(ret->accession), row[0]);
ret->dataType = cloneString(row[1]);
ret->lab = cloneString(row[2]);
ret->biosample = cloneString(row[3]);
ret->rfa = cloneString(row[4]);
ret->assayType = cloneString(row[5]);
ret->ipTarget = cloneString(row[6]);
ret->control = cloneString(row[7]);
return ret;
}

struct edwExperiment *edwExperimentLoadAll(char *fileName) 
/* Load all edwExperiment from a whitespace-separated file.
 * Dispose of this with edwExperimentFreeList(). */
{
struct edwExperiment *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = edwExperimentLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwExperiment *edwExperimentLoadAllByChar(char *fileName, char chopper) 
/* Load all edwExperiment from a chopper separated file.
 * Dispose of this with edwExperimentFreeList(). */
{
struct edwExperiment *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwExperimentLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwExperiment *edwExperimentCommaIn(char **pS, struct edwExperiment *ret)
/* Create a edwExperiment out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwExperiment */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->accession, sizeof(ret->accession));
ret->dataType = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
ret->biosample = sqlStringComma(&s);
ret->rfa = sqlStringComma(&s);
ret->assayType = sqlStringComma(&s);
ret->ipTarget = sqlStringComma(&s);
ret->control = sqlStringComma(&s);
*pS = s;
return ret;
}

void edwExperimentFree(struct edwExperiment **pEl)
/* Free a single dynamically allocated edwExperiment such as created
 * with edwExperimentLoad(). */
{
struct edwExperiment *el;

if ((el = *pEl) == NULL) return;
freeMem(el->dataType);
freeMem(el->lab);
freeMem(el->biosample);
freeMem(el->rfa);
freeMem(el->assayType);
freeMem(el->ipTarget);
freeMem(el->control);
freez(pEl);
}

void edwExperimentFreeList(struct edwExperiment **pList)
/* Free a list of dynamically allocated edwExperiment's */
{
struct edwExperiment *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwExperimentFree(&el);
    }
*pList = NULL;
}

void edwExperimentOutput(struct edwExperiment *el, FILE *f, char sep, char lastSep) 
/* Print out edwExperiment.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->accession);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dataType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->biosample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rfa);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assayType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ipTarget);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->control);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *edwValidFileCommaSepFieldNames = "id,licensePlate,fileId,format,outputType,experiment,replicate,validKey,enrichedIn,ucscDb,itemCount,basesInItems,sampleCount,basesInSample,sampleBed,mapRatio,sampleCoverage,depth,singleQaStatus,replicateQaStatus,technicalReplicate,pairedEnd,qaVersion,uniqueMapRatio";

void edwValidFileStaticLoad(char **row, struct edwValidFile *ret)
/* Load a row from edwValidFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
safecpy(ret->licensePlate, sizeof(ret->licensePlate), row[1]);
ret->fileId = sqlUnsigned(row[2]);
ret->format = row[3];
ret->outputType = row[4];
ret->experiment = row[5];
ret->replicate = row[6];
ret->validKey = row[7];
ret->enrichedIn = row[8];
ret->ucscDb = row[9];
ret->itemCount = sqlLongLong(row[10]);
ret->basesInItems = sqlLongLong(row[11]);
ret->sampleCount = sqlLongLong(row[12]);
ret->basesInSample = sqlLongLong(row[13]);
ret->sampleBed = row[14];
ret->mapRatio = sqlDouble(row[15]);
ret->sampleCoverage = sqlDouble(row[16]);
ret->depth = sqlDouble(row[17]);
ret->singleQaStatus = sqlSigned(row[18]);
ret->replicateQaStatus = sqlSigned(row[19]);
ret->technicalReplicate = row[20];
ret->pairedEnd = row[21];
ret->qaVersion = sqlSigned(row[22]);
ret->uniqueMapRatio = sqlDouble(row[23]);
}

struct edwValidFile *edwValidFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwValidFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwValidFileFreeList(). */
{
struct edwValidFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwValidFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwValidFileSaveToDb(struct sqlConnection *conn, struct edwValidFile *el, char *tableName, int updateSize)
/* Save edwValidFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,'%s','%s','%s','%s','%s','%s','%s',%lld,%lld,%lld,%lld,'%s',%g,%g,%g,%d,%d,'%s','%s',%d,%g)", 
	tableName,  el->id,  el->licensePlate,  el->fileId,  el->format,  el->outputType,  el->experiment,  el->replicate,  el->validKey,  el->enrichedIn,  el->ucscDb,  el->itemCount,  el->basesInItems,  el->sampleCount,  el->basesInSample,  el->sampleBed,  el->mapRatio,  el->sampleCoverage,  el->depth,  el->singleQaStatus,  el->replicateQaStatus,  el->technicalReplicate,  el->pairedEnd,  el->qaVersion,  el->uniqueMapRatio);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwValidFile *edwValidFileLoad(char **row)
/* Load a edwValidFile from row fetched with select * from edwValidFile
 * from database.  Dispose of this with edwValidFileFree(). */
{
struct edwValidFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
safecpy(ret->licensePlate, sizeof(ret->licensePlate), row[1]);
ret->fileId = sqlUnsigned(row[2]);
ret->format = cloneString(row[3]);
ret->outputType = cloneString(row[4]);
ret->experiment = cloneString(row[5]);
ret->replicate = cloneString(row[6]);
ret->validKey = cloneString(row[7]);
ret->enrichedIn = cloneString(row[8]);
ret->ucscDb = cloneString(row[9]);
ret->itemCount = sqlLongLong(row[10]);
ret->basesInItems = sqlLongLong(row[11]);
ret->sampleCount = sqlLongLong(row[12]);
ret->basesInSample = sqlLongLong(row[13]);
ret->sampleBed = cloneString(row[14]);
ret->mapRatio = sqlDouble(row[15]);
ret->sampleCoverage = sqlDouble(row[16]);
ret->depth = sqlDouble(row[17]);
ret->singleQaStatus = sqlSigned(row[18]);
ret->replicateQaStatus = sqlSigned(row[19]);
ret->technicalReplicate = cloneString(row[20]);
ret->pairedEnd = cloneString(row[21]);
ret->qaVersion = sqlSigned(row[22]);
ret->uniqueMapRatio = sqlDouble(row[23]);
return ret;
}

struct edwValidFile *edwValidFileLoadAll(char *fileName) 
/* Load all edwValidFile from a whitespace-separated file.
 * Dispose of this with edwValidFileFreeList(). */
{
struct edwValidFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileRow(lf, row))
    {
    el = edwValidFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwValidFile *edwValidFileLoadAllByChar(char *fileName, char chopper) 
/* Load all edwValidFile from a chopper separated file.
 * Dispose of this with edwValidFileFreeList(). */
{
struct edwValidFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwValidFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwValidFile *edwValidFileCommaIn(char **pS, struct edwValidFile *ret)
/* Create a edwValidFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwValidFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->licensePlate, sizeof(ret->licensePlate));
ret->fileId = sqlUnsignedComma(&s);
ret->format = sqlStringComma(&s);
ret->outputType = sqlStringComma(&s);
ret->experiment = sqlStringComma(&s);
ret->replicate = sqlStringComma(&s);
ret->validKey = sqlStringComma(&s);
ret->enrichedIn = sqlStringComma(&s);
ret->ucscDb = sqlStringComma(&s);
ret->itemCount = sqlLongLongComma(&s);
ret->basesInItems = sqlLongLongComma(&s);
ret->sampleCount = sqlLongLongComma(&s);
ret->basesInSample = sqlLongLongComma(&s);
ret->sampleBed = sqlStringComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
ret->sampleCoverage = sqlDoubleComma(&s);
ret->depth = sqlDoubleComma(&s);
ret->singleQaStatus = sqlSignedComma(&s);
ret->replicateQaStatus = sqlSignedComma(&s);
ret->technicalReplicate = sqlStringComma(&s);
ret->pairedEnd = sqlStringComma(&s);
ret->qaVersion = sqlSignedComma(&s);
ret->uniqueMapRatio = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwValidFileFree(struct edwValidFile **pEl)
/* Free a single dynamically allocated edwValidFile such as created
 * with edwValidFileLoad(). */
{
struct edwValidFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->format);
freeMem(el->outputType);
freeMem(el->experiment);
freeMem(el->replicate);
freeMem(el->validKey);
freeMem(el->enrichedIn);
freeMem(el->ucscDb);
freeMem(el->sampleBed);
freeMem(el->technicalReplicate);
freeMem(el->pairedEnd);
freez(pEl);
}

void edwValidFileFreeList(struct edwValidFile **pList)
/* Free a list of dynamically allocated edwValidFile's */
{
struct edwValidFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwValidFileFree(&el);
    }
*pList = NULL;
}

void edwValidFileOutput(struct edwValidFile *el, FILE *f, char sep, char lastSep) 
/* Print out edwValidFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->licensePlate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->format);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->outputType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->experiment);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->replicate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->validKey);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->enrichedIn);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ucscDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->itemCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInItems);
fputc(sep,f);
fprintf(f, "%lld", el->sampleCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSample);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleBed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(sep,f);
fprintf(f, "%g", el->sampleCoverage);
fputc(sep,f);
fprintf(f, "%g", el->depth);
fputc(sep,f);
fprintf(f, "%d", el->singleQaStatus);
fputc(sep,f);
fprintf(f, "%d", el->replicateQaStatus);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->technicalReplicate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pairedEnd);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->qaVersion);
fputc(sep,f);
fprintf(f, "%g", el->uniqueMapRatio);
fputc(lastSep,f);
}


char *edwFastqFileCommaSepFieldNames = "id,fileId,sampleCount,basesInSample,sampleFileName,readCount,baseCount,readSizeMean,readSizeStd,readSizeMin,readSizeMax,qualMean,qualStd,qualMin,qualMax,qualType,qualZero,atRatio,aRatio,cRatio,gRatio,tRatio,nRatio,qualPos,aAtPos,cAtPos,gAtPos,tAtPos,nAtPos";

struct edwFastqFile *edwFastqFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwFastqFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwFastqFileFreeList(). */
{
struct edwFastqFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwFastqFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwFastqFileSaveToDb(struct sqlConnection *conn, struct edwFastqFile *el, char *tableName, int updateSize)
/* Save edwFastqFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
char  *qualPosArray, *aAtPosArray, *cAtPosArray, *gAtPosArray, *tAtPosArray, *nAtPosArray;
qualPosArray = sqlDoubleArrayToString(el->qualPos, el->readSizeMax);
aAtPosArray = sqlDoubleArrayToString(el->aAtPos, el->readSizeMax);
cAtPosArray = sqlDoubleArrayToString(el->cAtPos, el->readSizeMax);
gAtPosArray = sqlDoubleArrayToString(el->gAtPos, el->readSizeMax);
tAtPosArray = sqlDoubleArrayToString(el->tAtPos, el->readSizeMax);
nAtPosArray = sqlDoubleArrayToString(el->nAtPos, el->readSizeMax);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%lld,%lld,'%s',%lld,%lld,%g,%g,%d,%d,%g,%g,%g,%g,'%s',%d,%g,%g,%g,%g,%g,%g,'%s','%s','%s','%s','%s','%s')", 
	tableName,  el->id,  el->fileId,  el->sampleCount,  el->basesInSample,  el->sampleFileName,  el->readCount,  el->baseCount,  el->readSizeMean,  el->readSizeStd,  el->readSizeMin,  el->readSizeMax,  el->qualMean,  el->qualStd,  el->qualMin,  el->qualMax,  el->qualType,  el->qualZero,  el->atRatio,  el->aRatio,  el->cRatio,  el->gRatio,  el->tRatio,  el->nRatio,  qualPosArray ,  aAtPosArray ,  cAtPosArray ,  gAtPosArray ,  tAtPosArray ,  nAtPosArray );
sqlUpdate(conn, update->string);
dyStringFree(&update);
freez(&qualPosArray);
freez(&aAtPosArray);
freez(&cAtPosArray);
freez(&gAtPosArray);
freez(&tAtPosArray);
freez(&nAtPosArray);
}

struct edwFastqFile *edwFastqFileLoad(char **row)
/* Load a edwFastqFile from row fetched with select * from edwFastqFile
 * from database.  Dispose of this with edwFastqFileFree(). */
{
struct edwFastqFile *ret;

AllocVar(ret);
ret->readSizeMax = sqlSigned(row[10]);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleCount = sqlLongLong(row[2]);
ret->basesInSample = sqlLongLong(row[3]);
ret->sampleFileName = cloneString(row[4]);
ret->readCount = sqlLongLong(row[5]);
ret->baseCount = sqlLongLong(row[6]);
ret->readSizeMean = sqlDouble(row[7]);
ret->readSizeStd = sqlDouble(row[8]);
ret->readSizeMin = sqlSigned(row[9]);
ret->qualMean = sqlDouble(row[11]);
ret->qualStd = sqlDouble(row[12]);
ret->qualMin = sqlDouble(row[13]);
ret->qualMax = sqlDouble(row[14]);
ret->qualType = cloneString(row[15]);
ret->qualZero = sqlSigned(row[16]);
ret->atRatio = sqlDouble(row[17]);
ret->aRatio = sqlDouble(row[18]);
ret->cRatio = sqlDouble(row[19]);
ret->gRatio = sqlDouble(row[20]);
ret->tRatio = sqlDouble(row[21]);
ret->nRatio = sqlDouble(row[22]);
{
int sizeOne;
sqlDoubleDynamicArray(row[23], &ret->qualPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[24], &ret->aAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[25], &ret->cAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[26], &ret->gAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[27], &ret->tAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[28], &ret->nAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
return ret;
}

struct edwFastqFile *edwFastqFileLoadAll(char *fileName) 
/* Load all edwFastqFile from a whitespace-separated file.
 * Dispose of this with edwFastqFileFreeList(). */
{
struct edwFastqFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[29];

while (lineFileRow(lf, row))
    {
    el = edwFastqFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwFastqFile *edwFastqFileLoadAllByChar(char *fileName, char chopper) 
/* Load all edwFastqFile from a chopper separated file.
 * Dispose of this with edwFastqFileFreeList(). */
{
struct edwFastqFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[29];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwFastqFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwFastqFile *edwFastqFileCommaIn(char **pS, struct edwFastqFile *ret)
/* Create a edwFastqFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwFastqFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->sampleCount = sqlLongLongComma(&s);
ret->basesInSample = sqlLongLongComma(&s);
ret->sampleFileName = sqlStringComma(&s);
ret->readCount = sqlLongLongComma(&s);
ret->baseCount = sqlLongLongComma(&s);
ret->readSizeMean = sqlDoubleComma(&s);
ret->readSizeStd = sqlDoubleComma(&s);
ret->readSizeMin = sqlSignedComma(&s);
ret->readSizeMax = sqlSignedComma(&s);
ret->qualMean = sqlDoubleComma(&s);
ret->qualStd = sqlDoubleComma(&s);
ret->qualMin = sqlDoubleComma(&s);
ret->qualMax = sqlDoubleComma(&s);
ret->qualType = sqlStringComma(&s);
ret->qualZero = sqlSignedComma(&s);
ret->atRatio = sqlDoubleComma(&s);
ret->aRatio = sqlDoubleComma(&s);
ret->cRatio = sqlDoubleComma(&s);
ret->gRatio = sqlDoubleComma(&s);
ret->tRatio = sqlDoubleComma(&s);
ret->nRatio = sqlDoubleComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->qualPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->qualPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->aAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->aAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->cAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->cAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->gAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->gAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->tAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->tAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->nAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->nAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void edwFastqFileFree(struct edwFastqFile **pEl)
/* Free a single dynamically allocated edwFastqFile such as created
 * with edwFastqFileLoad(). */
{
struct edwFastqFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->sampleFileName);
freeMem(el->qualType);
freeMem(el->qualPos);
freeMem(el->aAtPos);
freeMem(el->cAtPos);
freeMem(el->gAtPos);
freeMem(el->tAtPos);
freeMem(el->nAtPos);
freez(pEl);
}

void edwFastqFileFreeList(struct edwFastqFile **pList)
/* Free a list of dynamically allocated edwFastqFile's */
{
struct edwFastqFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwFastqFileFree(&el);
    }
*pList = NULL;
}

void edwFastqFileOutput(struct edwFastqFile *el, FILE *f, char sep, char lastSep) 
/* Print out edwFastqFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%lld", el->sampleCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSample);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->readCount);
fputc(sep,f);
fprintf(f, "%lld", el->baseCount);
fputc(sep,f);
fprintf(f, "%g", el->readSizeMean);
fputc(sep,f);
fprintf(f, "%g", el->readSizeStd);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMin);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMax);
fputc(sep,f);
fprintf(f, "%g", el->qualMean);
fputc(sep,f);
fprintf(f, "%g", el->qualStd);
fputc(sep,f);
fprintf(f, "%g", el->qualMin);
fputc(sep,f);
fprintf(f, "%g", el->qualMax);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qualType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->qualZero);
fputc(sep,f);
fprintf(f, "%g", el->atRatio);
fputc(sep,f);
fprintf(f, "%g", el->aRatio);
fputc(sep,f);
fprintf(f, "%g", el->cRatio);
fputc(sep,f);
fprintf(f, "%g", el->gRatio);
fputc(sep,f);
fprintf(f, "%g", el->tRatio);
fputc(sep,f);
fprintf(f, "%g", el->nRatio);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->qualPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->aAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->cAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->gAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->tAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->nAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}


char *edwBamFileCommaSepFieldNames = "id,fileId,isPaired,isSortedByTarget,readCount,readBaseCount,mappedCount,uniqueMappedCount,readSizeMean,readSizeStd,readSizeMin,readSizeMax,u4mReadCount,u4mUniquePos,u4mUniqueRatio,targetBaseCount,targetSeqCount";

void edwBamFileStaticLoad(char **row, struct edwBamFile *ret)
/* Load a row from edwBamFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->isPaired = sqlSigned(row[2]);
ret->isSortedByTarget = sqlSigned(row[3]);
ret->readCount = sqlLongLong(row[4]);
ret->readBaseCount = sqlLongLong(row[5]);
ret->mappedCount = sqlLongLong(row[6]);
ret->uniqueMappedCount = sqlLongLong(row[7]);
ret->readSizeMean = sqlDouble(row[8]);
ret->readSizeStd = sqlDouble(row[9]);
ret->readSizeMin = sqlSigned(row[10]);
ret->readSizeMax = sqlSigned(row[11]);
ret->u4mReadCount = sqlSigned(row[12]);
ret->u4mUniquePos = sqlSigned(row[13]);
ret->u4mUniqueRatio = sqlDouble(row[14]);
ret->targetBaseCount = sqlLongLong(row[15]);
ret->targetSeqCount = sqlUnsigned(row[16]);
}

struct edwBamFile *edwBamFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwBamFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwBamFileFreeList(). */
{
struct edwBamFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwBamFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwBamFileSaveToDb(struct sqlConnection *conn, struct edwBamFile *el, char *tableName, int updateSize)
/* Save edwBamFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%d,%d,%lld,%lld,%lld,%lld,%g,%g,%d,%d,%d,%d,%g,%lld,%u)", 
	tableName,  el->id,  el->fileId,  el->isPaired,  el->isSortedByTarget,  el->readCount,  el->readBaseCount,  el->mappedCount,  el->uniqueMappedCount,  el->readSizeMean,  el->readSizeStd,  el->readSizeMin,  el->readSizeMax,  el->u4mReadCount,  el->u4mUniquePos,  el->u4mUniqueRatio,  el->targetBaseCount,  el->targetSeqCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwBamFile *edwBamFileLoad(char **row)
/* Load a edwBamFile from row fetched with select * from edwBamFile
 * from database.  Dispose of this with edwBamFileFree(). */
{
struct edwBamFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->isPaired = sqlSigned(row[2]);
ret->isSortedByTarget = sqlSigned(row[3]);
ret->readCount = sqlLongLong(row[4]);
ret->readBaseCount = sqlLongLong(row[5]);
ret->mappedCount = sqlLongLong(row[6]);
ret->uniqueMappedCount = sqlLongLong(row[7]);
ret->readSizeMean = sqlDouble(row[8]);
ret->readSizeStd = sqlDouble(row[9]);
ret->readSizeMin = sqlSigned(row[10]);
ret->readSizeMax = sqlSigned(row[11]);
ret->u4mReadCount = sqlSigned(row[12]);
ret->u4mUniquePos = sqlSigned(row[13]);
ret->u4mUniqueRatio = sqlDouble(row[14]);
ret->targetBaseCount = sqlLongLong(row[15]);
ret->targetSeqCount = sqlUnsigned(row[16]);
return ret;
}

struct edwBamFile *edwBamFileLoadAll(char *fileName) 
/* Load all edwBamFile from a whitespace-separated file.
 * Dispose of this with edwBamFileFreeList(). */
{
struct edwBamFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[17];

while (lineFileRow(lf, row))
    {
    el = edwBamFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwBamFile *edwBamFileLoadAllByChar(char *fileName, char chopper) 
/* Load all edwBamFile from a chopper separated file.
 * Dispose of this with edwBamFileFreeList(). */
{
struct edwBamFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[17];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwBamFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwBamFile *edwBamFileCommaIn(char **pS, struct edwBamFile *ret)
/* Create a edwBamFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwBamFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->isPaired = sqlSignedComma(&s);
ret->isSortedByTarget = sqlSignedComma(&s);
ret->readCount = sqlLongLongComma(&s);
ret->readBaseCount = sqlLongLongComma(&s);
ret->mappedCount = sqlLongLongComma(&s);
ret->uniqueMappedCount = sqlLongLongComma(&s);
ret->readSizeMean = sqlDoubleComma(&s);
ret->readSizeStd = sqlDoubleComma(&s);
ret->readSizeMin = sqlSignedComma(&s);
ret->readSizeMax = sqlSignedComma(&s);
ret->u4mReadCount = sqlSignedComma(&s);
ret->u4mUniquePos = sqlSignedComma(&s);
ret->u4mUniqueRatio = sqlDoubleComma(&s);
ret->targetBaseCount = sqlLongLongComma(&s);
ret->targetSeqCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void edwBamFileFree(struct edwBamFile **pEl)
/* Free a single dynamically allocated edwBamFile such as created
 * with edwBamFileLoad(). */
{
struct edwBamFile *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwBamFileFreeList(struct edwBamFile **pList)
/* Free a list of dynamically allocated edwBamFile's */
{
struct edwBamFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwBamFileFree(&el);
    }
*pList = NULL;
}

void edwBamFileOutput(struct edwBamFile *el, FILE *f, char sep, char lastSep) 
/* Print out edwBamFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%d", el->isPaired);
fputc(sep,f);
fprintf(f, "%d", el->isSortedByTarget);
fputc(sep,f);
fprintf(f, "%lld", el->readCount);
fputc(sep,f);
fprintf(f, "%lld", el->readBaseCount);
fputc(sep,f);
fprintf(f, "%lld", el->mappedCount);
fputc(sep,f);
fprintf(f, "%lld", el->uniqueMappedCount);
fputc(sep,f);
fprintf(f, "%g", el->readSizeMean);
fputc(sep,f);
fprintf(f, "%g", el->readSizeStd);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMin);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMax);
fputc(sep,f);
fprintf(f, "%d", el->u4mReadCount);
fputc(sep,f);
fprintf(f, "%d", el->u4mUniquePos);
fputc(sep,f);
fprintf(f, "%g", el->u4mUniqueRatio);
fputc(sep,f);
fprintf(f, "%lld", el->targetBaseCount);
fputc(sep,f);
fprintf(f, "%u", el->targetSeqCount);
fputc(lastSep,f);
}


char *edwQaFailCommaSepFieldNames = "id,fileId,qaVersion,reason";

void edwQaFailStaticLoad(char **row, struct edwQaFail *ret)
/* Load a row from edwQaFail table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaVersion = sqlUnsigned(row[2]);
ret->reason = row[3];
}

struct edwQaFail *edwQaFailLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaFail from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaFailFreeList(). */
{
struct edwQaFail *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaFailLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaFailSaveToDb(struct sqlConnection *conn, struct edwQaFail *el, char *tableName, int updateSize)
/* Save edwQaFail as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,'%s')", 
	tableName,  el->id,  el->fileId,  el->qaVersion,  el->reason);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaFail *edwQaFailLoad(char **row)
/* Load a edwQaFail from row fetched with select * from edwQaFail
 * from database.  Dispose of this with edwQaFailFree(). */
{
struct edwQaFail *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaVersion = sqlUnsigned(row[2]);
ret->reason = cloneString(row[3]);
return ret;
}

struct edwQaFail *edwQaFailLoadAll(char *fileName) 
/* Load all edwQaFail from a whitespace-separated file.
 * Dispose of this with edwQaFailFreeList(). */
{
struct edwQaFail *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = edwQaFailLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaFail *edwQaFailLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaFail from a chopper separated file.
 * Dispose of this with edwQaFailFreeList(). */
{
struct edwQaFail *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaFailLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaFail *edwQaFailCommaIn(char **pS, struct edwQaFail *ret)
/* Create a edwQaFail out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaFail */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaVersion = sqlUnsignedComma(&s);
ret->reason = sqlStringComma(&s);
*pS = s;
return ret;
}

void edwQaFailFree(struct edwQaFail **pEl)
/* Free a single dynamically allocated edwQaFail such as created
 * with edwQaFailLoad(). */
{
struct edwQaFail *el;

if ((el = *pEl) == NULL) return;
freeMem(el->reason);
freez(pEl);
}

void edwQaFailFreeList(struct edwQaFail **pList)
/* Free a list of dynamically allocated edwQaFail's */
{
struct edwQaFail *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaFailFree(&el);
    }
*pList = NULL;
}

void edwQaFailOutput(struct edwQaFail *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaFail.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaVersion);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->reason);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *edwQaEnrichTargetCommaSepFieldNames = "id,assemblyId,name,fileId,targetSize";

void edwQaEnrichTargetStaticLoad(char **row, struct edwQaEnrichTarget *ret)
/* Load a row from edwQaEnrichTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->fileId = sqlUnsigned(row[3]);
ret->targetSize = sqlLongLong(row[4]);
}

struct edwQaEnrichTarget *edwQaEnrichTargetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaEnrichTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaEnrichTargetFreeList(). */
{
struct edwQaEnrichTarget *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaEnrichTargetSaveToDb(struct sqlConnection *conn, struct edwQaEnrichTarget *el, char *tableName, int updateSize)
/* Save edwQaEnrichTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%u,%lld)", 
	tableName,  el->id,  el->assemblyId,  el->name,  el->fileId,  el->targetSize);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaEnrichTarget *edwQaEnrichTargetLoad(char **row)
/* Load a edwQaEnrichTarget from row fetched with select * from edwQaEnrichTarget
 * from database.  Dispose of this with edwQaEnrichTargetFree(). */
{
struct edwQaEnrichTarget *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->fileId = sqlUnsigned(row[3]);
ret->targetSize = sqlLongLong(row[4]);
return ret;
}

struct edwQaEnrichTarget *edwQaEnrichTargetLoadAll(char *fileName) 
/* Load all edwQaEnrichTarget from a whitespace-separated file.
 * Dispose of this with edwQaEnrichTargetFreeList(). */
{
struct edwQaEnrichTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = edwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaEnrichTarget *edwQaEnrichTargetLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaEnrichTarget from a chopper separated file.
 * Dispose of this with edwQaEnrichTargetFreeList(). */
{
struct edwQaEnrichTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaEnrichTarget *edwQaEnrichTargetCommaIn(char **pS, struct edwQaEnrichTarget *ret)
/* Create a edwQaEnrichTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaEnrichTarget */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->assemblyId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->targetSize = sqlLongLongComma(&s);
*pS = s;
return ret;
}

void edwQaEnrichTargetFree(struct edwQaEnrichTarget **pEl)
/* Free a single dynamically allocated edwQaEnrichTarget such as created
 * with edwQaEnrichTargetLoad(). */
{
struct edwQaEnrichTarget *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void edwQaEnrichTargetFreeList(struct edwQaEnrichTarget **pList)
/* Free a list of dynamically allocated edwQaEnrichTarget's */
{
struct edwQaEnrichTarget *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaEnrichTargetFree(&el);
    }
*pList = NULL;
}

void edwQaEnrichTargetOutput(struct edwQaEnrichTarget *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaEnrichTarget.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->assemblyId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%lld", el->targetSize);
fputc(lastSep,f);
}


char *edwQaEnrichCommaSepFieldNames = "id,fileId,qaEnrichTargetId,targetBaseHits,targetUniqHits,coverage,enrichment,uniqEnrich";

void edwQaEnrichStaticLoad(char **row, struct edwQaEnrich *ret)
/* Load a row from edwQaEnrich table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaEnrichTargetId = sqlUnsigned(row[2]);
ret->targetBaseHits = sqlLongLong(row[3]);
ret->targetUniqHits = sqlLongLong(row[4]);
ret->coverage = sqlDouble(row[5]);
ret->enrichment = sqlDouble(row[6]);
ret->uniqEnrich = sqlDouble(row[7]);
}

struct edwQaEnrich *edwQaEnrichLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaEnrich from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaEnrichFreeList(). */
{
struct edwQaEnrich *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaEnrichSaveToDb(struct sqlConnection *conn, struct edwQaEnrich *el, char *tableName, int updateSize)
/* Save edwQaEnrich as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%lld,%lld,%g,%g,%g)", 
	tableName,  el->id,  el->fileId,  el->qaEnrichTargetId,  el->targetBaseHits,  el->targetUniqHits,  el->coverage,  el->enrichment,  el->uniqEnrich);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaEnrich *edwQaEnrichLoad(char **row)
/* Load a edwQaEnrich from row fetched with select * from edwQaEnrich
 * from database.  Dispose of this with edwQaEnrichFree(). */
{
struct edwQaEnrich *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaEnrichTargetId = sqlUnsigned(row[2]);
ret->targetBaseHits = sqlLongLong(row[3]);
ret->targetUniqHits = sqlLongLong(row[4]);
ret->coverage = sqlDouble(row[5]);
ret->enrichment = sqlDouble(row[6]);
ret->uniqEnrich = sqlDouble(row[7]);
return ret;
}

struct edwQaEnrich *edwQaEnrichLoadAll(char *fileName) 
/* Load all edwQaEnrich from a whitespace-separated file.
 * Dispose of this with edwQaEnrichFreeList(). */
{
struct edwQaEnrich *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = edwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaEnrich *edwQaEnrichLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaEnrich from a chopper separated file.
 * Dispose of this with edwQaEnrichFreeList(). */
{
struct edwQaEnrich *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaEnrich *edwQaEnrichCommaIn(char **pS, struct edwQaEnrich *ret)
/* Create a edwQaEnrich out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaEnrich */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaEnrichTargetId = sqlUnsignedComma(&s);
ret->targetBaseHits = sqlLongLongComma(&s);
ret->targetUniqHits = sqlLongLongComma(&s);
ret->coverage = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->uniqEnrich = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaEnrichFree(struct edwQaEnrich **pEl)
/* Free a single dynamically allocated edwQaEnrich such as created
 * with edwQaEnrichLoad(). */
{
struct edwQaEnrich *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaEnrichFreeList(struct edwQaEnrich **pList)
/* Free a list of dynamically allocated edwQaEnrich's */
{
struct edwQaEnrich *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaEnrichFree(&el);
    }
*pList = NULL;
}

void edwQaEnrichOutput(struct edwQaEnrich *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaEnrich.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaEnrichTargetId);
fputc(sep,f);
fprintf(f, "%lld", el->targetBaseHits);
fputc(sep,f);
fprintf(f, "%lld", el->targetUniqHits);
fputc(sep,f);
fprintf(f, "%g", el->coverage);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%g", el->uniqEnrich);
fputc(lastSep,f);
}


char *edwQaContamTargetCommaSepFieldNames = "id,assemblyId";

void edwQaContamTargetStaticLoad(char **row, struct edwQaContamTarget *ret)
/* Load a row from edwQaContamTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
}

struct edwQaContamTarget *edwQaContamTargetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaContamTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaContamTargetFreeList(). */
{
struct edwQaContamTarget *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaContamTargetSaveToDb(struct sqlConnection *conn, struct edwQaContamTarget *el, char *tableName, int updateSize)
/* Save edwQaContamTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u)", 
	tableName,  el->id,  el->assemblyId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaContamTarget *edwQaContamTargetLoad(char **row)
/* Load a edwQaContamTarget from row fetched with select * from edwQaContamTarget
 * from database.  Dispose of this with edwQaContamTargetFree(). */
{
struct edwQaContamTarget *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
return ret;
}

struct edwQaContamTarget *edwQaContamTargetLoadAll(char *fileName) 
/* Load all edwQaContamTarget from a whitespace-separated file.
 * Dispose of this with edwQaContamTargetFreeList(). */
{
struct edwQaContamTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = edwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaContamTarget *edwQaContamTargetLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaContamTarget from a chopper separated file.
 * Dispose of this with edwQaContamTargetFreeList(). */
{
struct edwQaContamTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaContamTarget *edwQaContamTargetCommaIn(char **pS, struct edwQaContamTarget *ret)
/* Create a edwQaContamTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaContamTarget */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->assemblyId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void edwQaContamTargetFree(struct edwQaContamTarget **pEl)
/* Free a single dynamically allocated edwQaContamTarget such as created
 * with edwQaContamTargetLoad(). */
{
struct edwQaContamTarget *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaContamTargetFreeList(struct edwQaContamTarget **pList)
/* Free a list of dynamically allocated edwQaContamTarget's */
{
struct edwQaContamTarget *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaContamTargetFree(&el);
    }
*pList = NULL;
}

void edwQaContamTargetOutput(struct edwQaContamTarget *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaContamTarget.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->assemblyId);
fputc(lastSep,f);
}


char *edwQaContamCommaSepFieldNames = "id,fileId,qaContamTargetId,mapRatio";

void edwQaContamStaticLoad(char **row, struct edwQaContam *ret)
/* Load a row from edwQaContam table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaContamTargetId = sqlUnsigned(row[2]);
ret->mapRatio = sqlDouble(row[3]);
}

struct edwQaContam *edwQaContamLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaContam from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaContamFreeList(). */
{
struct edwQaContam *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaContamLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaContamSaveToDb(struct sqlConnection *conn, struct edwQaContam *el, char *tableName, int updateSize)
/* Save edwQaContam as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g)", 
	tableName,  el->id,  el->fileId,  el->qaContamTargetId,  el->mapRatio);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaContam *edwQaContamLoad(char **row)
/* Load a edwQaContam from row fetched with select * from edwQaContam
 * from database.  Dispose of this with edwQaContamFree(). */
{
struct edwQaContam *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaContamTargetId = sqlUnsigned(row[2]);
ret->mapRatio = sqlDouble(row[3]);
return ret;
}

struct edwQaContam *edwQaContamLoadAll(char *fileName) 
/* Load all edwQaContam from a whitespace-separated file.
 * Dispose of this with edwQaContamFreeList(). */
{
struct edwQaContam *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = edwQaContamLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaContam *edwQaContamLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaContam from a chopper separated file.
 * Dispose of this with edwQaContamFreeList(). */
{
struct edwQaContam *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaContamLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaContam *edwQaContamCommaIn(char **pS, struct edwQaContam *ret)
/* Create a edwQaContam out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaContam */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaContamTargetId = sqlUnsignedComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaContamFree(struct edwQaContam **pEl)
/* Free a single dynamically allocated edwQaContam such as created
 * with edwQaContamLoad(). */
{
struct edwQaContam *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaContamFreeList(struct edwQaContam **pList)
/* Free a list of dynamically allocated edwQaContam's */
{
struct edwQaContam *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaContamFree(&el);
    }
*pList = NULL;
}

void edwQaContamOutput(struct edwQaContam *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaContam.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaContamTargetId);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(lastSep,f);
}


char *edwQaRepeatCommaSepFieldNames = "id,fileId,repeatClass,mapRatio";

void edwQaRepeatStaticLoad(char **row, struct edwQaRepeat *ret)
/* Load a row from edwQaRepeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->repeatClass = row[2];
ret->mapRatio = sqlDouble(row[3]);
}

struct edwQaRepeat *edwQaRepeatLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaRepeat from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaRepeatFreeList(). */
{
struct edwQaRepeat *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaRepeatSaveToDb(struct sqlConnection *conn, struct edwQaRepeat *el, char *tableName, int updateSize)
/* Save edwQaRepeat as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%g)", 
	tableName,  el->id,  el->fileId,  el->repeatClass,  el->mapRatio);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaRepeat *edwQaRepeatLoad(char **row)
/* Load a edwQaRepeat from row fetched with select * from edwQaRepeat
 * from database.  Dispose of this with edwQaRepeatFree(). */
{
struct edwQaRepeat *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->repeatClass = cloneString(row[2]);
ret->mapRatio = sqlDouble(row[3]);
return ret;
}

struct edwQaRepeat *edwQaRepeatLoadAll(char *fileName) 
/* Load all edwQaRepeat from a whitespace-separated file.
 * Dispose of this with edwQaRepeatFreeList(). */
{
struct edwQaRepeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = edwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaRepeat *edwQaRepeatLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaRepeat from a chopper separated file.
 * Dispose of this with edwQaRepeatFreeList(). */
{
struct edwQaRepeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaRepeat *edwQaRepeatCommaIn(char **pS, struct edwQaRepeat *ret)
/* Create a edwQaRepeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaRepeat */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->repeatClass = sqlStringComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaRepeatFree(struct edwQaRepeat **pEl)
/* Free a single dynamically allocated edwQaRepeat such as created
 * with edwQaRepeatLoad(). */
{
struct edwQaRepeat *el;

if ((el = *pEl) == NULL) return;
freeMem(el->repeatClass);
freez(pEl);
}

void edwQaRepeatFreeList(struct edwQaRepeat **pList)
/* Free a list of dynamically allocated edwQaRepeat's */
{
struct edwQaRepeat *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaRepeatFree(&el);
    }
*pList = NULL;
}

void edwQaRepeatOutput(struct edwQaRepeat *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaRepeat.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->repeatClass);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(lastSep,f);
}


char *edwQaPairSampleOverlapCommaSepFieldNames = "id,elderFileId,youngerFileId,elderSampleBases,youngerSampleBases,sampleOverlapBases,sampleSampleEnrichment";

void edwQaPairSampleOverlapStaticLoad(char **row, struct edwQaPairSampleOverlap *ret)
/* Load a row from edwQaPairSampleOverlap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->elderSampleBases = sqlLongLong(row[3]);
ret->youngerSampleBases = sqlLongLong(row[4]);
ret->sampleOverlapBases = sqlLongLong(row[5]);
ret->sampleSampleEnrichment = sqlDouble(row[6]);
}

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaPairSampleOverlap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */
{
struct edwQaPairSampleOverlap *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaPairSampleOverlapSaveToDb(struct sqlConnection *conn, struct edwQaPairSampleOverlap *el, char *tableName, int updateSize)
/* Save edwQaPairSampleOverlap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%lld,%lld,%lld,%g)", 
	tableName,  el->id,  el->elderFileId,  el->youngerFileId,  el->elderSampleBases,  el->youngerSampleBases,  el->sampleOverlapBases,  el->sampleSampleEnrichment);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoad(char **row)
/* Load a edwQaPairSampleOverlap from row fetched with select * from edwQaPairSampleOverlap
 * from database.  Dispose of this with edwQaPairSampleOverlapFree(). */
{
struct edwQaPairSampleOverlap *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->elderSampleBases = sqlLongLong(row[3]);
ret->youngerSampleBases = sqlLongLong(row[4]);
ret->sampleOverlapBases = sqlLongLong(row[5]);
ret->sampleSampleEnrichment = sqlDouble(row[6]);
return ret;
}

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadAll(char *fileName) 
/* Load all edwQaPairSampleOverlap from a whitespace-separated file.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */
{
struct edwQaPairSampleOverlap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = edwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaPairSampleOverlap from a chopper separated file.
 * Dispose of this with edwQaPairSampleOverlapFreeList(). */
{
struct edwQaPairSampleOverlap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairSampleOverlap *edwQaPairSampleOverlapCommaIn(char **pS, struct edwQaPairSampleOverlap *ret)
/* Create a edwQaPairSampleOverlap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairSampleOverlap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->elderFileId = sqlUnsignedComma(&s);
ret->youngerFileId = sqlUnsignedComma(&s);
ret->elderSampleBases = sqlLongLongComma(&s);
ret->youngerSampleBases = sqlLongLongComma(&s);
ret->sampleOverlapBases = sqlLongLongComma(&s);
ret->sampleSampleEnrichment = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaPairSampleOverlapFree(struct edwQaPairSampleOverlap **pEl)
/* Free a single dynamically allocated edwQaPairSampleOverlap such as created
 * with edwQaPairSampleOverlapLoad(). */
{
struct edwQaPairSampleOverlap *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaPairSampleOverlapFreeList(struct edwQaPairSampleOverlap **pList)
/* Free a list of dynamically allocated edwQaPairSampleOverlap's */
{
struct edwQaPairSampleOverlap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaPairSampleOverlapFree(&el);
    }
*pList = NULL;
}

void edwQaPairSampleOverlapOutput(struct edwQaPairSampleOverlap *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaPairSampleOverlap.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->elderFileId);
fputc(sep,f);
fprintf(f, "%u", el->youngerFileId);
fputc(sep,f);
fprintf(f, "%lld", el->elderSampleBases);
fputc(sep,f);
fprintf(f, "%lld", el->youngerSampleBases);
fputc(sep,f);
fprintf(f, "%lld", el->sampleOverlapBases);
fputc(sep,f);
fprintf(f, "%g", el->sampleSampleEnrichment);
fputc(lastSep,f);
}


char *edwQaPairCorrelationCommaSepFieldNames = "id,elderFileId,youngerFileId,pearsonInEnriched,pearsonOverall,pearsonClipped";

void edwQaPairCorrelationStaticLoad(char **row, struct edwQaPairCorrelation *ret)
/* Load a row from edwQaPairCorrelation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->pearsonInEnriched = sqlDouble(row[3]);
ret->pearsonOverall = sqlDouble(row[4]);
ret->pearsonClipped = sqlDouble(row[5]);
}

struct edwQaPairCorrelation *edwQaPairCorrelationLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaPairCorrelation from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairCorrelationFreeList(). */
{
struct edwQaPairCorrelation *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaPairCorrelationSaveToDb(struct sqlConnection *conn, struct edwQaPairCorrelation *el, char *tableName, int updateSize)
/* Save edwQaPairCorrelation as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%g)", 
	tableName,  el->id,  el->elderFileId,  el->youngerFileId,  el->pearsonInEnriched,  el->pearsonOverall,  el->pearsonClipped);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaPairCorrelation *edwQaPairCorrelationLoad(char **row)
/* Load a edwQaPairCorrelation from row fetched with select * from edwQaPairCorrelation
 * from database.  Dispose of this with edwQaPairCorrelationFree(). */
{
struct edwQaPairCorrelation *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->pearsonInEnriched = sqlDouble(row[3]);
ret->pearsonOverall = sqlDouble(row[4]);
ret->pearsonClipped = sqlDouble(row[5]);
return ret;
}

struct edwQaPairCorrelation *edwQaPairCorrelationLoadAll(char *fileName) 
/* Load all edwQaPairCorrelation from a whitespace-separated file.
 * Dispose of this with edwQaPairCorrelationFreeList(). */
{
struct edwQaPairCorrelation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = edwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairCorrelation *edwQaPairCorrelationLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaPairCorrelation from a chopper separated file.
 * Dispose of this with edwQaPairCorrelationFreeList(). */
{
struct edwQaPairCorrelation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairCorrelation *edwQaPairCorrelationCommaIn(char **pS, struct edwQaPairCorrelation *ret)
/* Create a edwQaPairCorrelation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairCorrelation */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->elderFileId = sqlUnsignedComma(&s);
ret->youngerFileId = sqlUnsignedComma(&s);
ret->pearsonInEnriched = sqlDoubleComma(&s);
ret->pearsonOverall = sqlDoubleComma(&s);
ret->pearsonClipped = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaPairCorrelationFree(struct edwQaPairCorrelation **pEl)
/* Free a single dynamically allocated edwQaPairCorrelation such as created
 * with edwQaPairCorrelationLoad(). */
{
struct edwQaPairCorrelation *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaPairCorrelationFreeList(struct edwQaPairCorrelation **pList)
/* Free a list of dynamically allocated edwQaPairCorrelation's */
{
struct edwQaPairCorrelation *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaPairCorrelationFree(&el);
    }
*pList = NULL;
}

void edwQaPairCorrelationOutput(struct edwQaPairCorrelation *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaPairCorrelation.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->elderFileId);
fputc(sep,f);
fprintf(f, "%u", el->youngerFileId);
fputc(sep,f);
fprintf(f, "%g", el->pearsonInEnriched);
fputc(sep,f);
fprintf(f, "%g", el->pearsonOverall);
fputc(sep,f);
fprintf(f, "%g", el->pearsonClipped);
fputc(lastSep,f);
}


char *edwQaPairedEndFastqCommaSepFieldNames = "id,fileId1,fileId2,concordance,distanceMean,distanceStd,distanceMin,distanceMax,recordComplete";

void edwQaPairedEndFastqStaticLoad(char **row, struct edwQaPairedEndFastq *ret)
/* Load a row from edwQaPairedEndFastq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId1 = sqlUnsigned(row[1]);
ret->fileId2 = sqlUnsigned(row[2]);
ret->concordance = sqlDouble(row[3]);
ret->distanceMean = sqlDouble(row[4]);
ret->distanceStd = sqlDouble(row[5]);
ret->distanceMin = sqlDouble(row[6]);
ret->distanceMax = sqlDouble(row[7]);
ret->recordComplete = sqlSigned(row[8]);
}

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaPairedEndFastq from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */
{
struct edwQaPairedEndFastq *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaPairedEndFastqSaveToDb(struct sqlConnection *conn, struct edwQaPairedEndFastq *el, char *tableName, int updateSize)
/* Save edwQaPairedEndFastq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%g,%g,%g,%d)", 
	tableName,  el->id,  el->fileId1,  el->fileId2,  el->concordance,  el->distanceMean,  el->distanceStd,  el->distanceMin,  el->distanceMax,  el->recordComplete);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoad(char **row)
/* Load a edwQaPairedEndFastq from row fetched with select * from edwQaPairedEndFastq
 * from database.  Dispose of this with edwQaPairedEndFastqFree(). */
{
struct edwQaPairedEndFastq *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId1 = sqlUnsigned(row[1]);
ret->fileId2 = sqlUnsigned(row[2]);
ret->concordance = sqlDouble(row[3]);
ret->distanceMean = sqlDouble(row[4]);
ret->distanceStd = sqlDouble(row[5]);
ret->distanceMin = sqlDouble(row[6]);
ret->distanceMax = sqlDouble(row[7]);
ret->recordComplete = sqlSigned(row[8]);
return ret;
}

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadAll(char *fileName) 
/* Load all edwQaPairedEndFastq from a whitespace-separated file.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */
{
struct edwQaPairedEndFastq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = edwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairedEndFastq *edwQaPairedEndFastqLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaPairedEndFastq from a chopper separated file.
 * Dispose of this with edwQaPairedEndFastqFreeList(). */
{
struct edwQaPairedEndFastq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaPairedEndFastq *edwQaPairedEndFastqCommaIn(char **pS, struct edwQaPairedEndFastq *ret)
/* Create a edwQaPairedEndFastq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaPairedEndFastq */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId1 = sqlUnsignedComma(&s);
ret->fileId2 = sqlUnsignedComma(&s);
ret->concordance = sqlDoubleComma(&s);
ret->distanceMean = sqlDoubleComma(&s);
ret->distanceStd = sqlDoubleComma(&s);
ret->distanceMin = sqlDoubleComma(&s);
ret->distanceMax = sqlDoubleComma(&s);
ret->recordComplete = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwQaPairedEndFastqFree(struct edwQaPairedEndFastq **pEl)
/* Free a single dynamically allocated edwQaPairedEndFastq such as created
 * with edwQaPairedEndFastqLoad(). */
{
struct edwQaPairedEndFastq *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaPairedEndFastqFreeList(struct edwQaPairedEndFastq **pList)
/* Free a list of dynamically allocated edwQaPairedEndFastq's */
{
struct edwQaPairedEndFastq *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaPairedEndFastqFree(&el);
    }
*pList = NULL;
}

void edwQaPairedEndFastqOutput(struct edwQaPairedEndFastq *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaPairedEndFastq.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId1);
fputc(sep,f);
fprintf(f, "%u", el->fileId2);
fputc(sep,f);
fprintf(f, "%g", el->concordance);
fputc(sep,f);
fprintf(f, "%g", el->distanceMean);
fputc(sep,f);
fprintf(f, "%g", el->distanceStd);
fputc(sep,f);
fprintf(f, "%g", el->distanceMin);
fputc(sep,f);
fprintf(f, "%g", el->distanceMax);
fputc(sep,f);
fprintf(f, "%d", el->recordComplete);
fputc(lastSep,f);
}


char *edwQaWigSpotCommaSepFieldNames = "id,wigId,spotId,spotRatio,enrichment,basesInGenome,basesInSpots,sumSignal,spotSumSignal";

void edwQaWigSpotStaticLoad(char **row, struct edwQaWigSpot *ret)
/* Load a row from edwQaWigSpot table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->wigId = sqlUnsigned(row[1]);
ret->spotId = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
}

struct edwQaWigSpot *edwQaWigSpotLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaWigSpot from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaWigSpotFreeList(). */
{
struct edwQaWigSpot *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaWigSpotSaveToDb(struct sqlConnection *conn, struct edwQaWigSpot *el, char *tableName, int updateSize)
/* Save edwQaWigSpot as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%lld,%lld,%g,%g)", 
	tableName,  el->id,  el->wigId,  el->spotId,  el->spotRatio,  el->enrichment,  el->basesInGenome,  el->basesInSpots,  el->sumSignal,  el->spotSumSignal);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaWigSpot *edwQaWigSpotLoad(char **row)
/* Load a edwQaWigSpot from row fetched with select * from edwQaWigSpot
 * from database.  Dispose of this with edwQaWigSpotFree(). */
{
struct edwQaWigSpot *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->wigId = sqlUnsigned(row[1]);
ret->spotId = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
return ret;
}

struct edwQaWigSpot *edwQaWigSpotLoadAll(char *fileName) 
/* Load all edwQaWigSpot from a whitespace-separated file.
 * Dispose of this with edwQaWigSpotFreeList(). */
{
struct edwQaWigSpot *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = edwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaWigSpot *edwQaWigSpotLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaWigSpot from a chopper separated file.
 * Dispose of this with edwQaWigSpotFreeList(). */
{
struct edwQaWigSpot *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaWigSpot *edwQaWigSpotCommaIn(char **pS, struct edwQaWigSpot *ret)
/* Create a edwQaWigSpot out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaWigSpot */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->wigId = sqlUnsignedComma(&s);
ret->spotId = sqlUnsignedComma(&s);
ret->spotRatio = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->basesInGenome = sqlLongLongComma(&s);
ret->basesInSpots = sqlLongLongComma(&s);
ret->sumSignal = sqlDoubleComma(&s);
ret->spotSumSignal = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void edwQaWigSpotFree(struct edwQaWigSpot **pEl)
/* Free a single dynamically allocated edwQaWigSpot such as created
 * with edwQaWigSpotLoad(). */
{
struct edwQaWigSpot *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void edwQaWigSpotFreeList(struct edwQaWigSpot **pList)
/* Free a list of dynamically allocated edwQaWigSpot's */
{
struct edwQaWigSpot *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaWigSpotFree(&el);
    }
*pList = NULL;
}

void edwQaWigSpotOutput(struct edwQaWigSpot *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaWigSpot.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->wigId);
fputc(sep,f);
fprintf(f, "%u", el->spotId);
fputc(sep,f);
fprintf(f, "%g", el->spotRatio);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%lld", el->basesInGenome);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSpots);
fputc(sep,f);
fprintf(f, "%g", el->sumSignal);
fputc(sep,f);
fprintf(f, "%g", el->spotSumSignal);
fputc(lastSep,f);
}


char *edwQaDnaseSingleStats5mCommaSepFieldNames = "id,fileId,sampleReads,spotRatio,enrichment,basesInGenome,basesInSpots,sumSignal,spotSumSignal,estFragLength,corrEstFragLen,phantomPeak,corrPhantomPeak,argMinCorr,minCorr,nsc,rsc,rscQualityTag";

void edwQaDnaseSingleStats5mStaticLoad(char **row, struct edwQaDnaseSingleStats5m *ret)
/* Load a row from edwQaDnaseSingleStats5m table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleReads = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
ret->estFragLength = row[9];
ret->corrEstFragLen = row[10];
ret->phantomPeak = sqlSigned(row[11]);
ret->corrPhantomPeak = sqlDouble(row[12]);
ret->argMinCorr = sqlSigned(row[13]);
ret->minCorr = sqlDouble(row[14]);
ret->nsc = sqlDouble(row[15]);
ret->rsc = sqlDouble(row[16]);
ret->rscQualityTag = sqlSigned(row[17]);
}

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwQaDnaseSingleStats5m from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */
{
struct edwQaDnaseSingleStats5m *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwQaDnaseSingleStats5mSaveToDb(struct sqlConnection *conn, struct edwQaDnaseSingleStats5m *el, char *tableName, int updateSize)
/* Save edwQaDnaseSingleStats5m as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%lld,%lld,%g,%g,'%s','%s',%d,%g,%d,%g,%g,%g,%d)", 
	tableName,  el->id,  el->fileId,  el->sampleReads,  el->spotRatio,  el->enrichment,  el->basesInGenome,  el->basesInSpots,  el->sumSignal,  el->spotSumSignal,  el->estFragLength,  el->corrEstFragLen,  el->phantomPeak,  el->corrPhantomPeak,  el->argMinCorr,  el->minCorr,  el->nsc,  el->rsc,  el->rscQualityTag);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoad(char **row)
/* Load a edwQaDnaseSingleStats5m from row fetched with select * from edwQaDnaseSingleStats5m
 * from database.  Dispose of this with edwQaDnaseSingleStats5mFree(). */
{
struct edwQaDnaseSingleStats5m *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleReads = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
ret->estFragLength = cloneString(row[9]);
ret->corrEstFragLen = cloneString(row[10]);
ret->phantomPeak = sqlSigned(row[11]);
ret->corrPhantomPeak = sqlDouble(row[12]);
ret->argMinCorr = sqlSigned(row[13]);
ret->minCorr = sqlDouble(row[14]);
ret->nsc = sqlDouble(row[15]);
ret->rsc = sqlDouble(row[16]);
ret->rscQualityTag = sqlSigned(row[17]);
return ret;
}

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadAll(char *fileName) 
/* Load all edwQaDnaseSingleStats5m from a whitespace-separated file.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */
{
struct edwQaDnaseSingleStats5m *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = edwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mLoadAllByChar(char *fileName, char chopper) 
/* Load all edwQaDnaseSingleStats5m from a chopper separated file.
 * Dispose of this with edwQaDnaseSingleStats5mFreeList(). */
{
struct edwQaDnaseSingleStats5m *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwQaDnaseSingleStats5m *edwQaDnaseSingleStats5mCommaIn(char **pS, struct edwQaDnaseSingleStats5m *ret)
/* Create a edwQaDnaseSingleStats5m out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwQaDnaseSingleStats5m */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->sampleReads = sqlUnsignedComma(&s);
ret->spotRatio = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->basesInGenome = sqlLongLongComma(&s);
ret->basesInSpots = sqlLongLongComma(&s);
ret->sumSignal = sqlDoubleComma(&s);
ret->spotSumSignal = sqlDoubleComma(&s);
ret->estFragLength = sqlStringComma(&s);
ret->corrEstFragLen = sqlStringComma(&s);
ret->phantomPeak = sqlSignedComma(&s);
ret->corrPhantomPeak = sqlDoubleComma(&s);
ret->argMinCorr = sqlSignedComma(&s);
ret->minCorr = sqlDoubleComma(&s);
ret->nsc = sqlDoubleComma(&s);
ret->rsc = sqlDoubleComma(&s);
ret->rscQualityTag = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwQaDnaseSingleStats5mFree(struct edwQaDnaseSingleStats5m **pEl)
/* Free a single dynamically allocated edwQaDnaseSingleStats5m such as created
 * with edwQaDnaseSingleStats5mLoad(). */
{
struct edwQaDnaseSingleStats5m *el;

if ((el = *pEl) == NULL) return;
freeMem(el->estFragLength);
freeMem(el->corrEstFragLen);
freez(pEl);
}

void edwQaDnaseSingleStats5mFreeList(struct edwQaDnaseSingleStats5m **pList)
/* Free a list of dynamically allocated edwQaDnaseSingleStats5m's */
{
struct edwQaDnaseSingleStats5m *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwQaDnaseSingleStats5mFree(&el);
    }
*pList = NULL;
}

void edwQaDnaseSingleStats5mOutput(struct edwQaDnaseSingleStats5m *el, FILE *f, char sep, char lastSep) 
/* Print out edwQaDnaseSingleStats5m.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->sampleReads);
fputc(sep,f);
fprintf(f, "%g", el->spotRatio);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%lld", el->basesInGenome);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSpots);
fputc(sep,f);
fprintf(f, "%g", el->sumSignal);
fputc(sep,f);
fprintf(f, "%g", el->spotSumSignal);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->estFragLength);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->corrEstFragLen);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->phantomPeak);
fputc(sep,f);
fprintf(f, "%g", el->corrPhantomPeak);
fputc(sep,f);
fprintf(f, "%d", el->argMinCorr);
fputc(sep,f);
fprintf(f, "%g", el->minCorr);
fputc(sep,f);
fprintf(f, "%g", el->nsc);
fputc(sep,f);
fprintf(f, "%g", el->rsc);
fputc(sep,f);
fprintf(f, "%d", el->rscQualityTag);
fputc(lastSep,f);
}


char *edwJobCommaSepFieldNames = "id,commandLine,startTime,endTime,stderr,returnCode,pid";

void edwJobStaticLoad(char **row, struct edwJob *ret)
/* Load a row from edwJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->commandLine = row[1];
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = row[4];
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
}

struct edwJob *edwJobLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwJobFreeList(). */
{
struct edwJob *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwJobLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwJobSaveToDb(struct sqlConnection *conn, struct edwJob *el, char *tableName, int updateSize)
/* Save edwJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,'%s',%d,%d)", 
	tableName,  el->id,  el->commandLine,  el->startTime,  el->endTime,  el->stderr,  el->returnCode,  el->pid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwJob *edwJobLoad(char **row)
/* Load a edwJob from row fetched with select * from edwJob
 * from database.  Dispose of this with edwJobFree(). */
{
struct edwJob *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->commandLine = cloneString(row[1]);
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = cloneString(row[4]);
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
return ret;
}

struct edwJob *edwJobLoadAll(char *fileName) 
/* Load all edwJob from a whitespace-separated file.
 * Dispose of this with edwJobFreeList(). */
{
struct edwJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = edwJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwJob *edwJobLoadAllByChar(char *fileName, char chopper) 
/* Load all edwJob from a chopper separated file.
 * Dispose of this with edwJobFreeList(). */
{
struct edwJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwJob *edwJobCommaIn(char **pS, struct edwJob *ret)
/* Create a edwJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwJob */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->commandLine = sqlStringComma(&s);
ret->startTime = sqlLongLongComma(&s);
ret->endTime = sqlLongLongComma(&s);
ret->stderr = sqlStringComma(&s);
ret->returnCode = sqlSignedComma(&s);
ret->pid = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwJobFree(struct edwJob **pEl)
/* Free a single dynamically allocated edwJob such as created
 * with edwJobLoad(). */
{
struct edwJob *el;

if ((el = *pEl) == NULL) return;
freeMem(el->commandLine);
freeMem(el->stderr);
freez(pEl);
}

void edwJobFreeList(struct edwJob **pList)
/* Free a list of dynamically allocated edwJob's */
{
struct edwJob *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwJobFree(&el);
    }
*pList = NULL;
}

void edwJobOutput(struct edwJob *el, FILE *f, char sep, char lastSep) 
/* Print out edwJob.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commandLine);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startTime);
fputc(sep,f);
fprintf(f, "%lld", el->endTime);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stderr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->returnCode);
fputc(sep,f);
fprintf(f, "%d", el->pid);
fputc(lastSep,f);
}


char *edwSubmitJobCommaSepFieldNames = "id,commandLine,startTime,endTime,stderr,returnCode,pid";

void edwSubmitJobStaticLoad(char **row, struct edwSubmitJob *ret)
/* Load a row from edwSubmitJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->commandLine = row[1];
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = row[4];
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
}

struct edwSubmitJob *edwSubmitJobLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all edwSubmitJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with edwSubmitJobFreeList(). */
{
struct edwSubmitJob *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = edwSubmitJobLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void edwSubmitJobSaveToDb(struct sqlConnection *conn, struct edwSubmitJob *el, char *tableName, int updateSize)
/* Save edwSubmitJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,'%s',%d,%d)", 
	tableName,  el->id,  el->commandLine,  el->startTime,  el->endTime,  el->stderr,  el->returnCode,  el->pid);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct edwSubmitJob *edwSubmitJobLoad(char **row)
/* Load a edwSubmitJob from row fetched with select * from edwSubmitJob
 * from database.  Dispose of this with edwSubmitJobFree(). */
{
struct edwSubmitJob *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->commandLine = cloneString(row[1]);
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = cloneString(row[4]);
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
return ret;
}

struct edwSubmitJob *edwSubmitJobLoadAll(char *fileName) 
/* Load all edwSubmitJob from a whitespace-separated file.
 * Dispose of this with edwSubmitJobFreeList(). */
{
struct edwSubmitJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = edwSubmitJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmitJob *edwSubmitJobLoadAllByChar(char *fileName, char chopper) 
/* Load all edwSubmitJob from a chopper separated file.
 * Dispose of this with edwSubmitJobFreeList(). */
{
struct edwSubmitJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = edwSubmitJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct edwSubmitJob *edwSubmitJobCommaIn(char **pS, struct edwSubmitJob *ret)
/* Create a edwSubmitJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new edwSubmitJob */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->commandLine = sqlStringComma(&s);
ret->startTime = sqlLongLongComma(&s);
ret->endTime = sqlLongLongComma(&s);
ret->stderr = sqlStringComma(&s);
ret->returnCode = sqlSignedComma(&s);
ret->pid = sqlSignedComma(&s);
*pS = s;
return ret;
}

void edwSubmitJobFree(struct edwSubmitJob **pEl)
/* Free a single dynamically allocated edwSubmitJob such as created
 * with edwSubmitJobLoad(). */
{
struct edwSubmitJob *el;

if ((el = *pEl) == NULL) return;
freeMem(el->commandLine);
freeMem(el->stderr);
freez(pEl);
}

void edwSubmitJobFreeList(struct edwSubmitJob **pList)
/* Free a list of dynamically allocated edwSubmitJob's */
{
struct edwSubmitJob *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    edwSubmitJobFree(&el);
    }
*pList = NULL;
}

void edwSubmitJobOutput(struct edwSubmitJob *el, FILE *f, char sep, char lastSep) 
/* Print out edwSubmitJob.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commandLine);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startTime);
fputc(sep,f);
fprintf(f, "%lld", el->endTime);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stderr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->returnCode);
fputc(sep,f);
fprintf(f, "%d", el->pid);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

