/* wabAli.c was originally generated by the autoSql program, which also 
 * generated wabAli.h and wabAli.sql.  This module links the database and the RAM 
 * representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "jksql.h"
#include "wabAli.h"


void wabAliStaticLoad(char **row, struct wabAli *ret)
/* Load a row from wabAli table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->query = row[0];
ret->qStart = sqlUnsigned(row[1]);
ret->qEnd = sqlUnsigned(row[2]);
strcpy(ret->strand, row[3]);
ret->chrom = row[4];
ret->chromStart = sqlUnsigned(row[5]);
ret->chromEnd = sqlUnsigned(row[6]);
ret->milliScore = sqlUnsigned(row[7]);
ret->symCount = sqlUnsigned(row[8]);
ret->qSym = row[9];
ret->tSym = row[10];
ret->hSym = row[11];
}

struct wabAli *wabAliLoad(char **row)
/* Load a wabAli from row fetched with select * from wabAli
 * from database.  Dispose of this with wabAliFree(). */
{
struct wabAli *ret;

AllocVar(ret);
ret->query = cloneString(row[0]);
ret->qStart = sqlUnsigned(row[1]);
ret->qEnd = sqlUnsigned(row[2]);
strcpy(ret->strand, row[3]);
ret->chrom = cloneString(row[4]);
ret->chromStart = sqlUnsigned(row[5]);
ret->chromEnd = sqlUnsigned(row[6]);
ret->milliScore = sqlUnsigned(row[7]);
ret->symCount = sqlUnsigned(row[8]);
ret->qSym = cloneStringZ(row[9], ret->symCount);
ret->tSym = cloneStringZ(row[10], ret->symCount);
ret->hSym = cloneStringZ(row[11], ret->symCount);
return ret;
}

struct wabAli *wabAliCommaIn(char **pS, struct wabAli *ret)
/* Create a wabAli out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new wabAli */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->query = sqlStringComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->qEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->milliScore = sqlUnsignedComma(&s);
ret->symCount = sqlUnsignedComma(&s);
ret->qSym = sqlStringComma(&s);
ret->tSym = sqlStringComma(&s);
ret->hSym = sqlStringComma(&s);
*pS = s;
return ret;
}

void wabAliFree(struct wabAli **pEl)
/* Free a single dynamically allocated wabAli such as created
 * with wabAliLoad(). */
{
struct wabAli *el;

if ((el = *pEl) == NULL) return;
freeMem(el->query);
freeMem(el->chrom);
freeMem(el->qSym);
freeMem(el->tSym);
freeMem(el->hSym);
freez(pEl);
}

void wabAliFreeList(struct wabAli **pList)
/* Free a list of dynamically allocated wabAli's */
{
struct wabAli *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wabAliFree(&el);
    }
*pList = NULL;
}

void wabAliOutput(struct wabAli *el, FILE *f, char sep, char lastSep) 
/* Print out wabAli.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->query);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->qEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
fprintf(f, "%u", el->milliScore);
fputc(sep,f);
fprintf(f, "%u", el->symCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qSym);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tSym);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->hSym);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

