/* bigTransMap.c was originally generated by the autoSql program, which also 
 * generated bigTransMap.h and bigTransMap.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bigTransMap.h"



char *bigTransMapCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,thickStart,thickEnd,reserved,blockCount,blockSizes,chromStarts,oChromStart,oChromEnd,oStrand,oChromSize,oChromStarts,oSequence,oCDS,chromSize,match,misMatch,repMatch,nCount,seqType,srcDb,srcTransId,srcChrom,srcChromStart,srcChromEnd,srcIdent,srcAligned,geneName,geneId,geneType,transcriptType,chainType,commonName,scientificName,orgAbbrev";

struct bigTransMap *bigTransMapLoad(char **row)
/* Load a bigTransMap from row fetched with select * from bigTransMap
 * from database.  Dispose of this with bigTransMapFree(). */
{
struct bigTransMap *ret;

AllocVar(ret);
ret->blockCount = sqlSigned(row[9]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
{
int sizeOne;
sqlSignedDynamicArray(row[10], &ret->blockSizes, &sizeOne);
assert(sizeOne == ret->blockCount);
}
{
int sizeOne;
sqlSignedDynamicArray(row[11], &ret->chromStarts, &sizeOne);
assert(sizeOne == ret->blockCount);
}
ret->oChromStart = sqlUnsigned(row[12]);
ret->oChromEnd = sqlUnsigned(row[13]);
safecpy(ret->oStrand, sizeof(ret->oStrand), row[14]);
ret->oChromSize = sqlUnsigned(row[15]);
{
int sizeOne;
sqlSignedDynamicArray(row[16], &ret->oChromStarts, &sizeOne);
assert(sizeOne == ret->blockCount);
}
ret->oSequence = cloneString(row[17]);
ret->oCDS = cloneString(row[18]);
ret->chromSize = sqlUnsigned(row[19]);
ret->match = sqlUnsigned(row[20]);
ret->misMatch = sqlUnsigned(row[21]);
ret->repMatch = sqlUnsigned(row[22]);
ret->nCount = sqlUnsigned(row[23]);
ret->seqType = sqlUnsigned(row[24]);
ret->srcDb = cloneString(row[25]);
ret->srcTransId = cloneString(row[26]);
ret->srcChrom = cloneString(row[27]);
ret->srcChromStart = sqlUnsigned(row[28]);
ret->srcChromEnd = sqlUnsigned(row[29]);
ret->srcIdent = sqlUnsigned(row[30]);
ret->srcAligned = sqlUnsigned(row[31]);
ret->geneName = cloneString(row[32]);
ret->geneId = cloneString(row[33]);
ret->geneType = cloneString(row[34]);
ret->transcriptType = cloneString(row[35]);
ret->chainType = cloneString(row[36]);
ret->commonName = cloneString(row[37]);
ret->scientificName = cloneString(row[38]);
ret->orgAbbrev = cloneString(row[39]);
return ret;
}

struct bigTransMap *bigTransMapLoadAll(char *fileName) 
/* Load all bigTransMap from a whitespace-separated file.
 * Dispose of this with bigTransMapFreeList(). */
{
struct bigTransMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[40];

while (lineFileRow(lf, row))
    {
    el = bigTransMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigTransMap *bigTransMapLoadAllByChar(char *fileName, char chopper) 
/* Load all bigTransMap from a chopper separated file.
 * Dispose of this with bigTransMapFreeList(). */
{
struct bigTransMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[40];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bigTransMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigTransMap *bigTransMapCommaIn(char **pS, struct bigTransMap *ret)
/* Create a bigTransMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigTransMap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->blockCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->blockSizes, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->blockSizes[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->chromStarts, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->chromStarts[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->oChromStart = sqlUnsignedComma(&s);
ret->oChromEnd = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->oStrand, sizeof(ret->oStrand));
ret->oChromSize = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->oChromStarts, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->oChromStarts[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->oSequence = sqlStringComma(&s);
ret->oCDS = sqlStringComma(&s);
ret->chromSize = sqlUnsignedComma(&s);
ret->match = sqlUnsignedComma(&s);
ret->misMatch = sqlUnsignedComma(&s);
ret->repMatch = sqlUnsignedComma(&s);
ret->nCount = sqlUnsignedComma(&s);
ret->seqType = sqlUnsignedComma(&s);
ret->srcDb = sqlStringComma(&s);
ret->srcTransId = sqlStringComma(&s);
ret->srcChrom = sqlStringComma(&s);
ret->srcChromStart = sqlUnsignedComma(&s);
ret->srcChromEnd = sqlUnsignedComma(&s);
ret->srcIdent = sqlUnsignedComma(&s);
ret->srcAligned = sqlUnsignedComma(&s);
ret->geneName = sqlStringComma(&s);
ret->geneId = sqlStringComma(&s);
ret->geneType = sqlStringComma(&s);
ret->transcriptType = sqlStringComma(&s);
ret->chainType = sqlStringComma(&s);
ret->commonName = sqlStringComma(&s);
ret->scientificName = sqlStringComma(&s);
ret->orgAbbrev = sqlStringComma(&s);
*pS = s;
return ret;
}

void bigTransMapFree(struct bigTransMap **pEl)
/* Free a single dynamically allocated bigTransMap such as created
 * with bigTransMapLoad(). */
{
struct bigTransMap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->blockSizes);
freeMem(el->chromStarts);
freeMem(el->oChromStarts);
freeMem(el->oSequence);
freeMem(el->oCDS);
freeMem(el->srcDb);
freeMem(el->srcTransId);
freeMem(el->srcChrom);
freeMem(el->geneName);
freeMem(el->geneId);
freeMem(el->geneType);
freeMem(el->transcriptType);
freeMem(el->chainType);
freeMem(el->commonName);
freeMem(el->scientificName);
freeMem(el->orgAbbrev);
freez(pEl);
}

void bigTransMapFreeList(struct bigTransMap **pList)
/* Free a list of dynamically allocated bigTransMap's */
{
struct bigTransMap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bigTransMapFree(&el);
    }
*pList = NULL;
}

void bigTransMapOutput(struct bigTransMap *el, FILE *f, char sep, char lastSep) 
/* Print out bigTransMap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
fprintf(f, "%d", el->blockCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->blockSizes[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->chromStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%u", el->oChromStart);
fputc(sep,f);
fprintf(f, "%u", el->oChromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->oStrand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->oChromSize);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->oChromStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->oSequence);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->oCDS);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromSize);
fputc(sep,f);
fprintf(f, "%u", el->match);
fputc(sep,f);
fprintf(f, "%u", el->misMatch);
fputc(sep,f);
fprintf(f, "%u", el->repMatch);
fputc(sep,f);
fprintf(f, "%u", el->nCount);
fputc(sep,f);
fprintf(f, "%u", el->seqType);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcTransId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcChrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->srcChromStart);
fputc(sep,f);
fprintf(f, "%u", el->srcChromEnd);
fputc(sep,f);
fprintf(f, "%u", el->srcIdent);
fputc(sep,f);
fprintf(f, "%u", el->srcAligned);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcriptType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chainType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commonName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->scientificName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->orgAbbrev);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

