table dgvPlus
"Database of Genomic Variants incorporating dbVar, July 2013 and later"
    (
    string chrom;       "Reference sequence chromosome or scaffold"
    uint   chromStart;  "Start position in chromosome"
    uint   chromEnd;    "End position in chromosome"
    string name;        "ID of merged variant or supporting variant"
    uint   score;       "Score from 0-1000 (placeholder for BED 9+ format)"
    char[1] strand;     "+ or - (placeholder for BED 9+ format)"
    uint thickStart;    "Same as chromStart (placeholder for BED 9+ format)"
    uint thickEnd;      "Same as chromStart (placeholder for BED 9+ format)"
    uint itemRgb;	"Item R,G,B color."
    string varType;     "Type of variation"
    string reference;   "Literature reference for the study that included this variant"
    uint pubMedId;      "For linking to pubMed abstract of reference"
    lstring method;     "Brief description of method"
    lstring platform;    "Sequencing platform (if specified)"
    string mergedVariants; "If this is a supporting variant, ID of merged variant"
    lstring supportingVariants; "If this is a merged variant, IDs of supporting variants"
    uint sampleSize;    "Number of samples in study"
    uint observedGains; "Number of samples with copy number gains"
    uint observedLosses; "Number of samples with copy number losses"
    lstring cohortDescription; "Description of sample population for the study"
    lstring genes;      "Genes overlapping this variant"
    lstring samples;    "Sample IDs if available"
    )
