/* rikenBest.h was originally generated by the autoSql program, which also 
 * generated rikenBest.c and rikenBest.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef RIKENBEST_H
#define RIKENBEST_H

struct rikenBest
/* The best Riken mRNA in each cluster */
    {
    struct rikenBest *next;  /* Next in singly linked list. */
    char *name;	/* Riken mRNA ID */
    float orfScore;	/* Score from bestorf - 50 is decent */
    char orfStrand[2];	/* Strand bestorf is on: +, - or . */
    int intronOrientation;	/* +1 for each GT/AG intron, -1 for each CT/AC */
    char *position;	/* Position in genome of cluster chrN:start-end format */
    int rikenCount;	/* Number of Riken mRNAs in cluster */
    int genBankCount;	/* Number of Genbank mRNAs in cluster */
    int refSeqCount;	/* Number of RefSeq mRNAs in cluster */
    char *clusterId;	/* ID of cluster */
    };

void rikenBestStaticLoad(char **row, struct rikenBest *ret);
/* Load a row from rikenBest table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rikenBest *rikenBestLoad(char **row);
/* Load a rikenBest from row fetched with select * from rikenBest
 * from database.  Dispose of this with rikenBestFree(). */

struct rikenBest *rikenBestLoadAll(char *fileName);
/* Load all rikenBest from a tab-separated file.
 * Dispose of this with rikenBestFreeList(). */

struct rikenBest *rikenBestLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all rikenBest from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with rikenBestFreeList(). */

struct rikenBest *rikenBestCommaIn(char **pS, struct rikenBest *ret);
/* Create a rikenBest out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rikenBest */

void rikenBestFree(struct rikenBest **pEl);
/* Free a single dynamically allocated rikenBest such as created
 * with rikenBestLoad(). */

void rikenBestFreeList(struct rikenBest **pList);
/* Free a list of dynamically allocated rikenBest's */

void rikenBestOutput(struct rikenBest *el, FILE *f, char sep, char lastSep);
/* Print out rikenBest.  Separate fields with sep. Follow last field with lastSep. */

#define rikenBestTabOut(el,f) rikenBestOutput(el,f,'\t','\n');
/* Print out rikenBest as a line in a tab-separated file. */

#define rikenBestCommaOut(el,f) rikenBestOutput(el,f,',',',');
/* Print out rikenBest as a comma separated list including final comma. */

#endif /* RIKENBEST_H */

