/* gtexGeneBed.h was originally generated by the autoSql program, which also 
 * generated gtexGeneBed.c and gtexGeneBed.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GTEXGENEBED_H
#define GTEXGENEBED_H

#include "jksql.h"
#define GTEXGENEBED_NUM_COLS 10

extern char *gtexGeneBedCommaSepFieldNames;

struct gtexGeneBed
/* BED6+ with additional fields for gene and transcript IDs, and expression experiment scores */
    {
    struct gtexGeneBed *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Gene symbol */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - for strand */
    char *geneId;	/* Ensembl gene ID, referenced in GTEx data tables */
    char *geneType;	/* GENCODE gene biotype */
    unsigned expCount;	/* Number of experiment values */
    float *expScores;	/* Experiment scores */
    };

struct gtexGeneBed *gtexGeneBedLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all gtexGeneBed from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexGeneBedFreeList(). */

void gtexGeneBedSaveToDb(struct sqlConnection *conn, struct gtexGeneBed *el, char *tableName, int updateSize);
/* Save gtexGeneBed as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct gtexGeneBed *gtexGeneBedLoad(char **row);
/* Load a gtexGeneBed from row fetched with select * from gtexGeneBed
 * from database.  Dispose of this with gtexGeneBedFree(). */

struct gtexGeneBed *gtexGeneBedLoadAll(char *fileName);
/* Load all gtexGeneBed from whitespace-separated file.
 * Dispose of this with gtexGeneBedFreeList(). */

struct gtexGeneBed *gtexGeneBedLoadAllByChar(char *fileName, char chopper);
/* Load all gtexGeneBed from chopper separated file.
 * Dispose of this with gtexGeneBedFreeList(). */

#define gtexGeneBedLoadAllByTab(a) gtexGeneBedLoadAllByChar(a, '\t');
/* Load all gtexGeneBed from tab separated file.
 * Dispose of this with gtexGeneBedFreeList(). */

struct gtexGeneBed *gtexGeneBedCommaIn(char **pS, struct gtexGeneBed *ret);
/* Create a gtexGeneBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexGeneBed */

void gtexGeneBedFree(struct gtexGeneBed **pEl);
/* Free a single dynamically allocated gtexGeneBed such as created
 * with gtexGeneBedLoad(). */

void gtexGeneBedFreeList(struct gtexGeneBed **pList);
/* Free a list of dynamically allocated gtexGeneBed's */

void gtexGeneBedOutput(struct gtexGeneBed *el, FILE *f, char sep, char lastSep);
/* Print out gtexGeneBed.  Separate fields with sep. Follow last field with lastSep. */

#define gtexGeneBedTabOut(el,f) gtexGeneBedOutput(el,f,'\t','\n');
/* Print out gtexGeneBed as a line in a tab-separated file. */

#define gtexGeneBedCommaOut(el,f) gtexGeneBedOutput(el,f,',',',');
/* Print out gtexGeneBed as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */


void gtexGeneBedCreateTable(struct sqlConnection *conn, char *table);
/* Create expression record format table of given name. */

char *gtexVersionSuffix(char *table);
/* Return version string for a GTEx track table.  For now, just supporting V4 (no suffix) and V6 */

char *gtexGeneClass(struct gtexGeneBed *geneBed);
/* Return gene "class" (analogous to GENCODE transcriptClass) for a GENCODE gene biotype */

boolean gtexGeneIsCoding(struct gtexGeneBed *geneBed);
/* Return TRUE if biotype indicates this is a protein coding gene */

float gtexGeneTotalMedianExpression(struct gtexGeneBed *geneBed);
/* Return total of all tissue medians */

float gtexGeneHighestMedianExpression(struct gtexGeneBed *geneBed, int *tissueIdRet);
/* Return tissue median and id of tissue with highest expression of this gene */

#endif /* GTEXGENEBED_H */

