/* dgv.h was originally generated by the autoSql program, which also 
 * generated dgv.c and dgv.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef DGV_H
#define DGV_H

#define DGV_NUM_COLS 15

struct dgv
/* Database of Genomic Variants */
    {
    struct dgv *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned itemRgb;	/* Item R,G,B color. */
    char *landmark;	/* Genomic marker near the variation locus */
    char *varType;	/* Type of variation */
    char *reference;	/* Literature reference for the study that included this variant */
    unsigned pubMedId;	/* For linking to pubMed abstract of reference */
    char *method;	/* Brief description of method/platform */
    char *sample;	/* Description of sample population for the study */
    };

void dgvStaticLoad(char **row, struct dgv *ret);
/* Load a row from dgv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dgv *dgvLoad(char **row);
/* Load a dgv from row fetched with select * from dgv
 * from database.  Dispose of this with dgvFree(). */

struct dgv *dgvLoadAll(char *fileName);
/* Load all dgv from whitespace-separated file.
 * Dispose of this with dgvFreeList(). */

struct dgv *dgvLoadAllByChar(char *fileName, char chopper);
/* Load all dgv from chopper separated file.
 * Dispose of this with dgvFreeList(). */

#define dgvLoadAllByTab(a) dgvLoadAllByChar(a, '\t');
/* Load all dgv from tab separated file.
 * Dispose of this with dgvFreeList(). */

struct dgv *dgvCommaIn(char **pS, struct dgv *ret);
/* Create a dgv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dgv */

void dgvFree(struct dgv **pEl);
/* Free a single dynamically allocated dgv such as created
 * with dgvLoad(). */

void dgvFreeList(struct dgv **pList);
/* Free a list of dynamically allocated dgv's */

void dgvOutput(struct dgv *el, FILE *f, char sep, char lastSep);
/* Print out dgv.  Separate fields with sep. Follow last field with lastSep. */

#define dgvTabOut(el,f) dgvOutput(el,f,'\t','\n');
/* Print out dgv as a line in a tab-separated file. */

#define dgvCommaOut(el,f) dgvOutput(el,f,',',',');
/* Print out dgv as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DGV_H */

